/**
 * Take a Markdown string and generate HTML from it
 */
export declare function htmlFromMarkdown(markdown: string, options?: {
    removeTags?: string[];
    allowTags?: string[];
    transform?: (node: Record<string, any>) => Record<string, any>;
    transformType?: string;
}): string;
/**
 * Find all headings of a specific type in a Markdown AST.
 */
export declare function getHeadings(markdown: string, depth?: number): {
    depth: number;
    value: string;
}[];
/**
 * Return multiple Markdown documents. Every heading should be its own document.
 */
export declare function splitContent(markdown: string): string[];
//# sourceMappingURL=markdown.d.ts.map