import { defineComponent as s, openBlock as l, createElementBlock as r, normalizeClass as n, unref as t, createVNode as i, normalizeStyle as c, createElementVNode as p, renderSlot as m, createBlock as d, withModifiers as u, createCommentVNode as f } from "vue";
import { cva as b, cx as y } from "@scalar/use-hooks/useBindCx";
import v from "../ScalarListbox/ScalarListboxCheckbox.vue.js";
import k from "../ScalarIcon/ScalarIcon.vue.js";
const g = ["aria-selected"], B = { class: "inline-block min-w-0 flex-1 truncate text-c-1" }, $ = /* @__PURE__ */ s({
  __name: "ScalarComboboxOption",
  props: {
    active: { type: Boolean },
    selected: { type: Boolean },
    style: {},
    isDeletable: { type: Boolean }
  },
  emits: ["delete"],
  setup(h) {
    const a = b({
      base: [
        // Group
        "group/item",
        // Layout
        "flex min-w-0 items-center gap-1.5 rounded px-2 py-1.5 text-left",
        // Text / background style
        "truncate bg-transparent text-c-1",
        // Interaction
        "cursor-pointer hover:bg-b-2"
      ],
      variants: {
        selected: { true: "text-c-1" },
        active: { true: "bg-b-2" }
      }
    });
    return (e, o) => (l(), r("li", {
      "aria-selected": e.selected,
      class: n(t(y)(t(a)({ active: e.active, selected: e.selected }))),
      role: "option",
      tabindex: "-1"
    }, [
      i(t(v), {
        selected: e.selected,
        style: c(e.style)
      }, null, 8, ["selected", "style"]),
      p("span", B, [
        m(e.$slots, "default")
      ]),
      e.isDeletable ? (l(), d(t(k), {
        key: 0,
        "aria-label": "Delete",
        class: "text-c-2 opacity-0 group-hover/item:opacity-100",
        icon: "Delete",
        size: "md",
        thickness: "1.5",
        onClick: o[0] || (o[0] = u((x) => e.$emit("delete"), ["stop"]))
      })) : f("", !0)
    ], 10, g));
  }
});
export {
  $ as default
};
