import { type ScalarFloatingOptions } from '../ScalarFloating';
/**
 * Scalar dropdown component
 *
 * Uses the headlessui Menu component under the hood
 * @see https://headlessui.com/v1/vue/menu
 *
 * @example
 * <ScalarDropdown>
 *   <ScalarButton>Click Me</ScalarButton>
 *   <template #items>
 *     <ScalarDropdownItem>Item 1</ScalarDropdownItem>
 *     <ScalarDropdownItem>Item 2</ScalarDropdownItem>
 *   </template>
 * </ScalarDropdown>
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<ScalarFloatingOptions, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<ScalarFloatingOptions> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, Readonly<{
    /** The reference element for the element in the #floating slot */
    default(props: {
        /** Whether or not the dropdown is open */
        open: boolean;
    }): any;
    /** The list of dropdown items */
    items(props: {
        /** Whether or not the dropdown is open */
        open: boolean;
    }): any;
}> & {
    /** The reference element for the element in the #floating slot */
    default(props: {
        /** Whether or not the dropdown is open */
        open: boolean;
    }): any;
    /** The list of dropdown items */
    items(props: {
        /** Whether or not the dropdown is open */
        open: boolean;
    }): any;
}>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarDropdown.vue.d.ts.map