import type { LoadingState } from '../ScalarLoading';
import { type ExtensionList } from './types';
/**
 * Scalar File Upload component
 *
 * @example
 * <ScalarFileUpload @selected="handleSelected" />
 *
 * @example
 * <ScalarFileUpload v-slot="{ open }">
 *   <ScalarButton @click="open">Select files</ScalarButton>
 * </ScalarFileUpload>
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    modelValue?: File[];
    error?: string;
} & {
    /** Whether multiple files can be uploaded */
    multiple?: boolean;
    /**
     * Accepted file types
     * @default '*'
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/accept
     */
    accept?: ExtensionList | string;
    /** Whether the file upload is loading */
    loader?: LoadingState;
    /** Whether the file upload is compact */
    variant?: "compact" | "default";
}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {
    "update:modelValue": (value: File[]) => any;
    "update:error": (value: string) => any;
} & {
    selected: (value: File[]) => any;
}, string, import("vue").PublicProps, Readonly<{
    modelValue?: File[];
    error?: string;
} & {
    /** Whether multiple files can be uploaded */
    multiple?: boolean;
    /**
     * Accepted file types
     * @default '*'
     * @see https://developer.mozilla.org/en-US/docs/Web/HTML/Attributes/accept
     */
    accept?: ExtensionList | string;
    /** Whether the file upload is loading */
    loader?: LoadingState;
    /** Whether the file upload is compact */
    variant?: "compact" | "default";
}> & Readonly<{
    "onUpdate:modelValue"?: ((value: File[]) => any) | undefined;
    onSelected?: ((value: File[]) => any) | undefined;
    "onUpdate:error"?: ((value: string) => any) | undefined;
}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, Readonly<{
    /** Override the entire input */
    default?: (props: {
        /** Open the file dialog to select files */
        open: () => void;
    }) => any;
    /** Override the label */
    label?: () => any;
    /** Override the entire drop target */
    'drop-target'?: () => any;
    /** Override the drop target label */
    'drop-target-label'?: () => any;
}> & {
    /** Override the entire input */
    default?: (props: {
        /** Open the file dialog to select files */
        open: () => void;
    }) => any;
    /** Override the label */
    label?: () => any;
    /** Override the entire drop target */
    'drop-target'?: () => any;
    /** Override the drop target label */
    'drop-target-label'?: () => any;
}>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarFileUpload.vue.d.ts.map