/**
 * Scalar header component
 *
 * Used to create a standardized header for Scalar applications
 *
 * @example
 * ```html
 * <ScalarHeader>
 *   <template #start>
 *     <ScalarMenu />
 *     <ScalarHeaderButton>Login</ScalarHeaderButton>
 *     <ScalarHeaderButton>Register</ScalarHeaderButton>
 *   </template>
 *   <template #default>
 *     <ScalarHeaderButton>Middle thing</ScalarHeaderButton>
 *   </template>
 *   <template #end>
 *     <ScalarHeaderButton>Call to Action</ScalarHeaderButton>
 *   </template>
 * </ScalarHeader>
 * ```
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<{}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<{}> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, HTMLElement>, Readonly<{
    /** The first section of the header, typically on the left */
    start?: () => any;
    /** The middle section of the header */
    default?: () => any;
    /** The last section of the header, typically on the right */
    end?: () => any;
}> & {
    /** The first section of the header, typically on the left */
    start?: () => any;
    /** The middle section of the header */
    default?: () => any;
    /** The last section of the header, typically on the right */
    end?: () => any;
}>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarHeader.vue.d.ts.map