/**
 * Scalar teleport root component
 *
 * Provides a teleport target for nested <ScalarTeleport> components
 *
 * @example
 * <ScalarTeleportRoot>
 *   ...
 *   <ScalarTeleport>
 *     <div>Teleported Content</div>
 *   </ScalarTeleport>
 *   ...
 * </ScalarTeleportRoot>
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    /**
     * Override the default teleport target id
     */
    id?: string;
}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<{
    /**
     * Override the default teleport target id
     */
    id?: string;
}> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, Readonly<{
    /** The content which contains <ScalarTeleports> */
    default(): any;
}> & {
    /** The content which contains <ScalarTeleports> */
    default(): any;
}>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarTeleportRoot.vue.d.ts.map