import { type InjectionKey } from 'vue';
/**
 * The teleport target
 */
export declare const TELEPORT_SYMBOL: InjectionKey<string>;
/**
 * Get the nearest teleport target id from `useProvideTeleport`
 *
 * Falls back to `body` if no teleport target id is found
 *
 * @see {@link useProvideTeleport}
 */
export declare const useTeleport: () => string;
/**
 * Provides a teleport target id using Vue's `provide`
 *
 * @see https://vuejs.org/guide/components/provide-inject.html#provide-inject
 */
export declare const useProvideTeleport: (id?: string) => string;
//# sourceMappingURL=useTeleport.d.ts.map