import type { Component } from 'vue';
/**
 * Scalar dropdown menu component
 *
 * Provides a scrollable container for dropdown items
 * This is used internally by the ScalarDropdown component
 *
 * If you're looking to create a dropdown menu with a trigger
 * button you probably want the ScalarDropdown component
 *
 * @example
 * <ScalarDropdownMenu>
 *   <ScalarDropdownItem>Item 1</ScalarDropdownItem>
 *   <ScalarDropdownItem>Item 2</ScalarDropdownItem>
 * </ScalarDropdownMenu>
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    /** The component to render */
    is?: string | Component;
}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<{
    /** The component to render */
    is?: string | Component;
}> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, Readonly<{
    /** The menu contents */
    default(): any;
    /** Overrides the backdrop for the dropdown */
    backdrop?(): any;
}> & {
    /** The menu contents */
    default(): any;
    /** Overrides the backdrop for the dropdown */
    backdrop?(): any;
}>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarDropdownMenu.vue.d.ts.map