export type LoadingState = ReturnType<typeof useLoadingState>;
/**
 * Handles isLoading spinner for the FlowLoader Component
 * - stateIsLoading will trigger the spinner
 * - isValid or isInvalid will show a check or x and then spin out
 */
export declare function useLoadingState(): {
    isValid: boolean;
    isInvalid: boolean;
    isLoading: boolean;
    startLoading: () => void;
    stopLoading: () => void;
    validate: (time?: number, clear?: boolean) => Promise<unknown>;
    invalidate: (time?: number, clear?: boolean) => Promise<unknown>;
    clear: (time?: number) => Promise<unknown>;
};
declare const _default: import("vue").DefineComponent<{
    loadingState?: LoadingState;
    size?: "xs" | "sm" | "md" | "lg" | "xl" | "2xl" | "3xl" | "full" | undefined;
}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<{
    loadingState?: LoadingState;
    size?: "xs" | "sm" | "md" | "lg" | "xl" | "2xl" | "3xl" | "full" | undefined;
}> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>;
export default _default;
//# sourceMappingURL=ScalarLoading.vue.d.ts.map