/**
 * Scalar floating backdrop component
 *
 * Provides an absolutely positioned backdrop for the floating element
 * This is used internally by a number of the Scalar floating components
 * (e.g. Dropdown, Popover, Listbox)
 *
 * You can use this component directly if you need to customize the backdrop
 * for a floating component
 *
 * @example
 * <ScalarDropdown>
 *   <!-- Menu stuff -->
 *   <template #backdrop>
 *     <ScalarFloatingBackdrop />
 *   </template>
 * </ScalarDropdown>
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<{}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<{}> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, true, {}, any>, {
    default?(_: {}): any;
}>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarFloatingBackdrop.vue.d.ts.map