import { defineComponent as h, ref as v, computed as g, useAttrs as k, createElementBlock as S, openBlock as s, normalizeClass as i, unref as a, createBlock as o, createCommentVNode as c, createElementVNode as V, mergeProps as y, withModifiers as C } from "vue";
import { cva as z, cx as u } from "@scalar/use-hooks/useBindCx";
import B from "../ScalarIcon/ScalarIcon.vue.js";
import I from "../ScalarLoading/ScalarLoading.vue.js";
import w from "../ScalarIconButton/ScalarIconButton.vue.js";
const E = ["aria-label", "value"], M = /* @__PURE__ */ h({
  inheritAttrs: !1,
  __name: "ScalarSearchInput",
  props: {
    loading: {},
    modelValue: {},
    sidebar: { type: Boolean },
    label: {}
  },
  emits: ["update:modelValue"],
  setup(N, { expose: d, emit: p }) {
    const r = p, l = v(null);
    function m(e) {
      r("update:modelValue", e.target.value);
    }
    function f() {
      r("update:modelValue", ""), l.value && l.value.focus();
    }
    const t = g(() => {
      const { class: e, ...n } = k();
      return { class: e || "", rest: n };
    }), b = z({
      base: "search-background flex items-center rounded border text-sm font-medium has-[:focus-visible]:bg-b-1 has-[:focus-visible]:outline",
      variants: {
        sidebar: {
          true: "h-8 gap-2 px-1.5",
          false: "h-10 p-3"
        }
      }
    });
    return d({
      focus: () => {
        var e;
        (e = l.value) == null || e.focus();
      },
      blur: () => {
        var e;
        (e = l.value) == null || e.blur();
      }
    }), (e, n) => (s(), S("label", {
      class: i(a(u)(a(b)({ sidebar: e.sidebar }), t.value.class))
    }, [
      e.sidebar ? (s(), o(a(B), {
        key: 0,
        class: "text-c-2",
        icon: "Search",
        size: "xs",
        thickness: "2.5"
      })) : c("", !0),
      V("input", y({
        ref_key: "inputRef",
        ref: l
      }, t.value.rest, {
        "aria-label": e.label ?? "Enter search query",
        autocapitalize: "off",
        autocomplete: "off",
        autocorrect: "off",
        class: "flex-1 appearance-none rounded border-none bg-transparent outline-none",
        placeholder: "Search...",
        spellcheck: "false",
        type: "search",
        value: e.modelValue,
        onInput: m
      }), null, 16, E),
      e.loading && e.loading.isLoading ? (s(), o(a(I), {
        key: 1,
        class: "mr-3 self-center",
        loadingState: e.loading,
        size: "md"
      }, null, 8, ["loadingState"])) : e.modelValue ? (s(), o(a(w), {
        key: 2,
        class: i(a(u)("p-0", e.sidebar ? "h-4 w-4" : "h-5 w-5")),
        icon: "Close",
        label: "Clear Search",
        thickness: e.sidebar ? "1.75" : "1.5",
        onClick: C(f, ["stop", "prevent"])
      }, null, 8, ["class", "thickness"])) : c("", !0)
    ], 2));
  }
});
export {
  M as default
};
