import type { Component } from 'vue';
import { type SidebarGroupLevel } from './useSidebarGroups.js';
/**
 * Scalar Sidebar Group component
 *
 * A collapsible ScalarSidebarItem that can contain subitems
 *
 * @example
 * <ScalarSidebarGroup v-model="open">
 *   <!-- Group toggle text -->
 *   <template #items>
 *     <ScalarSidebarItem>...</ScalarSidebarItem>
 *     <ScalarSidebarItem>...</ScalarSidebarItem>
 *     <ScalarSidebarItem>...</ScalarSidebarItem>
 *   </template>
 * </ScalarSidebarGroup>
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    modelValue?: boolean;
} & {
    /** Override the element tag */
    is?: Component | string;
}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {
    "update:modelValue": (value: boolean) => any;
}, string, import("vue").PublicProps, Readonly<{
    modelValue?: boolean;
} & {
    /** Override the element tag */
    is?: Component | string;
}> & Readonly<{
    "onUpdate:modelValue"?: ((value: boolean) => any) | undefined;
}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, Readonly<{
    /** The text content of the toggle */
    default?: (props: {
        open: boolean;
    }) => any;
    /** Override the entire toggle button */
    button?: (props: {
        open: boolean;
        level: SidebarGroupLevel;
    }) => any;
    /** The list of sidebar subitems */
    items?: (props: {
        open: boolean;
    }) => any;
}> & {
    /** The text content of the toggle */
    default?: (props: {
        open: boolean;
    }) => any;
    /** Override the entire toggle button */
    button?: (props: {
        open: boolean;
        level: SidebarGroupLevel;
    }) => any;
    /** The list of sidebar subitems */
    items?: (props: {
        open: boolean;
    }) => any;
}>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarSidebarGroup.vue.d.ts.map