import type { ScalarSidebarItemProps, ScalarSidebarItemSlots } from './types';
/**
 * Scalar Sidebar Item component
 *
 * Provides a ScalarSidebarButton wrapped in an `<li>` to
 * meet accessibility requirements and automatically indents
 * the button based on the level of the sidebar group
 *
 * @example
 * <ScalarSidebarItem>
 *   <template #icon>
 *     <!-- Overrides the icon slot -->
 *   </template>
 *   <!-- Button text -->
 *   <template #aside>
 *     <!-- After the button text -->
 *   </template>
 * </ScalarSidebarItem>
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<ScalarSidebarItemProps, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<ScalarSidebarItemProps> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, Readonly<ScalarSidebarItemSlots> & ScalarSidebarItemSlots>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarSidebarItem.vue.d.ts.map