import { type InjectionKey } from 'vue';
/**
 * The level of the sidebar groups
 *
 * We shouldn't go deeper than 6 levels
 */
export type SidebarGroupLevel = 0 | 1 | 2 | 3 | 4 | 5 | 6;
/**
 * Tracks the level of the sidebar groups
 *
 * @default 0
 */
export declare const SIDEBAR_GROUPS_SYMBOL: InjectionKey<SidebarGroupLevel>;
/**
 * Get the current level of the sidebar groups
 *
 * Optionally increments the level of the sidebar groups
 */
export declare const useSidebarGroups: ({ increment, }?: {
    /** Whether to increment the level of the sidebar groups */
    increment?: boolean;
}) => {
    level: SidebarGroupLevel;
};
//# sourceMappingURL=useSidebarGroups.d.ts.map