import type { TeleportProps } from 'vue';
/**
 * Scalar teleport component
 *
 * Teleports the contents to the nearest <ScalarTeleportRoot>
 * Falls back to the default teleport target (body) if no root is found
 *
 * Is a wrapper around the Vue <Teleport> component and takes the same props
 *
 * @example
 *   <ScalarTeleport>
 *     <div>Teleported Content</div>
 *   </ScalarTeleport>
 */
declare const _default: __VLS_WithTemplateSlots<import("vue").DefineComponent<{
    /**
     * Override the default teleport target
     */
    to?: TeleportProps["to"];
    /**
     * Whether to teleport immediately, disables the default defer behavior
     *
     * @see https://vuejs.org/guide/built-ins/teleport#deferred-teleport
     */
    immediate?: boolean;
    /**
     * Whether to disable teleportation
     */
    disabled?: TeleportProps["disabled"];
}, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").PublicProps, Readonly<{
    /**
     * Override the default teleport target
     */
    to?: TeleportProps["to"];
    /**
     * Whether to teleport immediately, disables the default defer behavior
     *
     * @see https://vuejs.org/guide/built-ins/teleport#deferred-teleport
     */
    immediate?: boolean;
    /**
     * Whether to disable teleportation
     */
    disabled?: TeleportProps["disabled"];
}> & Readonly<{}>, {}, {}, {}, {}, string, import("vue").ComponentProvideOptions, false, {}, any>, Readonly<{
    /** The element to be teleported */
    default(): any;
}> & {
    /** The element to be teleported */
    default(): any;
}>;
export default _default;
type __VLS_WithTemplateSlots<T, S> = T & {
    new (): {
        $slots: S;
    };
};
//# sourceMappingURL=ScalarTeleport.vue.d.ts.map