function json2xml(data, tab) {
  const toXml = (value, key, indentation) => {
    let xml2 = "";
    if (Array.isArray(value)) {
      for (let i = 0, n = value.length; i < n; i++) {
        xml2 += indentation + toXml(value[i], key, indentation + "	") + "\n";
      }
    } else if (typeof value === "object") {
      let hasChild = false;
      xml2 += indentation + "<" + key;
      for (const m in value) {
        if (m.charAt(0) === "@") {
          xml2 += " " + m.substr(1) + '="' + value[m].toString() + '"';
        } else {
          hasChild = true;
        }
      }
      xml2 += hasChild ? ">" : "/>";
      if (hasChild) {
        for (const m in value) {
          if (m === "#text") {
            xml2 += value[m];
          } else if (m === "#cdata") {
            xml2 += "<![CDATA[" + value[m] + "]]>";
          } else if (m.charAt(0) !== "@") {
            xml2 += toXml(value[m], m, indentation + "	");
          }
        }
        xml2 += (xml2.charAt(xml2.length - 1) === "\n" ? indentation : "") + "</" + key + ">";
      }
    } else {
      xml2 += indentation + "<" + key + ">" + value.toString() + "</" + key + ">";
    }
    return xml2;
  };
  let xml = "";
  for (const key in data) {
    if (Object.hasOwn(data, key)) {
      xml += toXml(data[key], key, "");
    }
  }
  return tab ? xml.replace(/\t/g, tab) : xml.replace(/\t|\n/g, "");
}
export {
  json2xml
};
//# sourceMappingURL=json2xml.js.map
