function replaceVariables(value, variablesOrCallback) {
  const doubleCurlyBrackets = /{{\s*([\w.-]+)\s*}}/g;
  const singleCurlyBrackets = /{\s*([\w.-]+)\s*}/g;
  const callback = (_, match) => {
    if (typeof variablesOrCallback === "function") {
      return variablesOrCallback(match);
    }
    return variablesOrCallback[match]?.toString() || `{${match}}`;
  };
  return value.replace(doubleCurlyBrackets, callback).replace(singleCurlyBrackets, callback);
}
export {
  replaceVariables
};
//# sourceMappingURL=replace-variables.js.map
