const makeUrlAbsolute = (url, baseUrl) => {
  if (!url || url.startsWith("http://") || url.startsWith("https://") || typeof window === "undefined" && !baseUrl) {
    return url;
  }
  const base = baseUrl || window.location.href;
  const cleanBaseUrl = base.split("?")[0]?.split("#")[0];
  const normalizedBaseUrl = cleanBaseUrl?.endsWith("/") ? cleanBaseUrl : cleanBaseUrl?.substring(0, cleanBaseUrl?.lastIndexOf("/") + 1);
  return new URL(url, normalizedBaseUrl).toString();
};
export {
  makeUrlAbsolute
};
//# sourceMappingURL=make-url-absolute.js.map
