import microdiff from 'microdiff';

const types = {
    CREATE: 'add',
    REMOVE: 'remove',
    CHANGE: 'modify',
};
/**
 * Compare two specs and return the changes for each request entry
 *
 */
function diffSpec(a, b) {
    const diff = microdiff(a, b);
    const requestChanges = {};
    diff
        .filter((d) => d.path[0] === 'paths')
        .forEach((d) => {
        const key = d.path
            .slice(0, 3)
            .map((p) => String(p).replaceAll('/', '~1'))
            .join('/');
        if (!requestChanges[key])
            requestChanges[key] = {
                type: types[d.type],
                mutations: [],
            };
        if (d.type === 'CHANGE') {
            requestChanges[key].mutations.push({
                ...d,
                path: d.path.slice(3),
            });
        }
        else if (d.type === 'CREATE') {
            requestChanges[key].value = d.value;
        }
    });
    return JSON.stringify(requestChanges, null, 2);
}

export { diffSpec };
