/**
 * Aliases Request to Operation which is closer to the spec,
 * also will not conflict with the builtin Request class
 */
import { type RequestPayload, type Request as RequestType } from './requests.js';
export type Operation = RequestType;
export type OperationPayload = RequestPayload;
export declare const operationSchema: import("zod").ZodObject<import("zod").objectUtil.extendShape<Omit<{
    tags: import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodString, "many">>;
    summary: import("zod").ZodOptional<import("zod").ZodString>;
    description: import("zod").ZodOptional<import("zod").ZodString>;
    operationId: import("zod").ZodOptional<import("zod").ZodString>;
    security: import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodString, "many">>>>, "many">>;
    requestBody: import("zod").ZodOptional<import("zod").ZodAny>;
    parameters: import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodObject<{
        in: import("zod").ZodEnum<["path", "query", "header", "cookie"]>;
        name: import("zod").ZodString;
        description: import("zod").ZodOptional<import("zod").ZodString>;
        required: import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodBoolean>>;
        deprecated: import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodBoolean>>;
        schema: import("zod").ZodOptional<import("zod").ZodUnknown>;
        content: import("zod").ZodOptional<import("zod").ZodUnknown>;
        style: import("zod").ZodOptional<import("zod").ZodEnum<["matrix", "simple", "form", "label", "spaceDelimited", "pipeDelimited", "deepObject"]>>;
        example: import("zod").ZodOptional<import("zod").ZodUnknown>;
        examples: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodObject<{
            value: import("zod").ZodUnknown;
            summary: import("zod").ZodOptional<import("zod").ZodString>;
        }, "strip", import("zod").ZodTypeAny, {
            value?: unknown;
            summary?: string | undefined;
        }, {
            value?: unknown;
            summary?: string | undefined;
        }>>>;
    }, "strip", import("zod").ZodTypeAny, {
        required: boolean;
        name: string;
        in: "path" | "cookie" | "query" | "header";
        deprecated: boolean;
        example?: unknown;
        description?: string | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        examples?: Record<string, {
            value?: unknown;
            summary?: string | undefined;
        }> | undefined;
    }, {
        name: string;
        in: "path" | "cookie" | "query" | "header";
        example?: unknown;
        required?: boolean | undefined;
        description?: string | undefined;
        deprecated?: boolean | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        examples?: Record<string, {
            value?: unknown;
            summary?: string | undefined;
        }> | undefined;
    }>, "many">>;
    externalDocs: import("zod").ZodOptional<import("zod").ZodObject<{
        description: import("zod").ZodOptional<import("zod").ZodString>;
        url: import("zod").ZodDefault<import("zod").ZodString>;
    }, "strip", import("zod").ZodTypeAny, {
        url: string;
        description?: string | undefined;
    }, {
        description?: string | undefined;
        url?: string | undefined;
    }>>;
    deprecated: import("zod").ZodOptional<import("zod").ZodBoolean>;
    responses: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodAny>>;
    'x-scalar-examples': import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodObject<{
        name: import("zod").ZodOptional<import("zod").ZodString>;
        body: import("zod").ZodOptional<import("zod").ZodObject<{
            encoding: import("zod").ZodEnum<["application/json", "text/plain", "text/html", "application/javascript", "application/xml", "application/yaml", "application/edn", "application/octet-stream", "application/x-www-form-urlencoded", "multipart/form-data", "binary"]>;
            content: import("zod").ZodUnion<[import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodAny>, import("zod").ZodString]>;
            file: import("zod").ZodOptional<import("zod").ZodNullable<import("zod").ZodObject<{
                url: import("zod").ZodString;
                base64: import("zod").ZodOptional<import("zod").ZodString>;
            }, "strip", import("zod").ZodTypeAny, {
                url: string;
                base64?: string | undefined;
            }, {
                url: string;
                base64?: string | undefined;
            }>>>;
        }, "strip", import("zod").ZodTypeAny, {
            content: string | Record<string, any>;
            encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        }, {
            content: string | Record<string, any>;
            encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        }>>;
        parameters: import("zod").ZodObject<{
            path: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodString>>;
            query: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodString>>;
            headers: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodString>>;
            cookies: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodString>>;
        }, "strip", import("zod").ZodTypeAny, {
            path?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
        }, {
            path?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
        }>;
    }, "strip", import("zod").ZodTypeAny, {
        parameters: {
            path?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            content: string | Record<string, any>;
            encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }, {
        parameters: {
            path?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            content: string | Record<string, any>;
            encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }>>>;
    'x-internal': import("zod").ZodOptional<import("zod").ZodBoolean>;
    'x-scalar-ignore': import("zod").ZodOptional<import("zod").ZodBoolean>;
}, "x-scalar-examples">, {
    type: import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodLiteral<"request">>>;
    uid: import("zod").ZodBranded<import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodString>>, "operation">;
    path: import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodString>>;
    method: import("zod").ZodDefault<import("zod").ZodEnum<["connect", "delete", "get", "head", "options", "patch", "post", "put", "trace"]>>;
    servers: import("zod").ZodDefault<import("zod").ZodArray<import("zod").ZodBranded<import("zod").ZodString, "server">, "many">>;
    selectedServerUid: import("zod").ZodDefault<import("zod").ZodNullable<import("zod").ZodOptional<import("zod").ZodBranded<import("zod").ZodString, "server">>>>;
    examples: import("zod").ZodDefault<import("zod").ZodArray<import("zod").ZodBranded<import("zod").ZodString, "example">, "many">>;
    selectedSecuritySchemeUids: import("zod").ZodDefault<import("zod").ZodArray<import("zod").ZodUnion<[import("zod").ZodBranded<import("zod").ZodString, "securityScheme">, import("zod").ZodArray<import("zod").ZodBranded<import("zod").ZodString, "securityScheme">, "many">]>, "many">>;
}>, "strip", import("zod").ZodTypeAny, {
    path: string;
    type: "request";
    uid: string & import("zod").BRAND<"operation">;
    selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
    selectedServerUid: (string & import("zod").BRAND<"server">) | null;
    servers: (string & import("zod").BRAND<"server">)[];
    examples: (string & import("zod").BRAND<"example">)[];
    method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
    description?: string | undefined;
    summary?: string | undefined;
    externalDocs?: {
        url: string;
        description?: string | undefined;
    } | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    security?: Record<string, string[]>[] | undefined;
    tags?: string[] | undefined;
    deprecated?: boolean | undefined;
    operationId?: string | undefined;
    parameters?: {
        required: boolean;
        name: string;
        in: "path" | "cookie" | "query" | "header";
        deprecated: boolean;
        example?: unknown;
        description?: string | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        examples?: Record<string, {
            value?: unknown;
            summary?: string | undefined;
        }> | undefined;
    }[] | undefined;
    requestBody?: any;
    responses?: Record<string, any> | undefined;
}, {
    path?: string | undefined;
    type?: "request" | undefined;
    uid?: string | undefined;
    description?: string | undefined;
    summary?: string | undefined;
    externalDocs?: {
        description?: string | undefined;
        url?: string | undefined;
    } | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    security?: Record<string, string[] | undefined>[] | undefined;
    selectedSecuritySchemeUids?: (string | string[])[] | undefined;
    selectedServerUid?: string | null | undefined;
    servers?: string[] | undefined;
    tags?: string[] | undefined;
    deprecated?: boolean | undefined;
    examples?: string[] | undefined;
    operationId?: string | undefined;
    parameters?: {
        name: string;
        in: "path" | "cookie" | "query" | "header";
        example?: unknown;
        required?: boolean | undefined;
        description?: string | undefined;
        deprecated?: boolean | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        examples?: Record<string, {
            value?: unknown;
            summary?: string | undefined;
        }> | undefined;
    }[] | undefined;
    requestBody?: any;
    responses?: Record<string, any> | undefined;
    method?: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace" | undefined;
}>;
//# sourceMappingURL=operation.d.ts.map