import { z } from 'zod';
import type { RequestParameter } from './parameters.js';
import type { Request } from './requests.js';
import type { Server } from './server.js';
/**
 * TODO: Deprecate this.
 *
 * The request schema should be stored in the request and any
 * parameters should be validated against that
 */
export declare const requestExampleParametersSchema: z.ZodEffects<z.ZodObject<{
    key: z.ZodDefault<z.ZodString>;
    value: z.ZodDefault<z.ZodString>;
    enabled: z.ZodDefault<z.ZodBoolean>;
    file: z.ZodOptional<z.ZodAny>;
    description: z.ZodOptional<z.ZodString>;
    required: z.ZodOptional<z.ZodBoolean>;
    enum: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    examples: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    type: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
    format: z.ZodOptional<z.ZodString>;
    minimum: z.ZodOptional<z.ZodNumber>;
    maximum: z.ZodOptional<z.ZodNumber>;
    default: z.ZodOptional<z.ZodAny>;
    nullable: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    value: string;
    key: string;
    enabled: boolean;
    minimum?: number | undefined;
    type?: string | string[] | undefined;
    maximum?: number | undefined;
    default?: any;
    required?: boolean | undefined;
    description?: string | undefined;
    enum?: string[] | undefined;
    examples?: string[] | undefined;
    format?: string | undefined;
    file?: any;
    nullable?: boolean | undefined;
}, {
    minimum?: number | undefined;
    type?: string | string[] | undefined;
    maximum?: number | undefined;
    value?: string | undefined;
    default?: any;
    required?: boolean | undefined;
    description?: string | undefined;
    enum?: string[] | undefined;
    examples?: string[] | undefined;
    format?: string | undefined;
    file?: any;
    key?: string | undefined;
    enabled?: boolean | undefined;
    nullable?: boolean | undefined;
}>, {
    value: string;
    key: string;
    enabled: boolean;
    minimum?: number | undefined;
    type?: string | string[] | undefined;
    maximum?: number | undefined;
    default?: any;
    required?: boolean | undefined;
    description?: string | undefined;
    enum?: string[] | undefined;
    examples?: string[] | undefined;
    format?: string | undefined;
    file?: any;
    nullable?: boolean | undefined;
}, {
    minimum?: number | undefined;
    type?: string | string[] | undefined;
    maximum?: number | undefined;
    value?: string | undefined;
    default?: any;
    required?: boolean | undefined;
    description?: string | undefined;
    enum?: string[] | undefined;
    examples?: string[] | undefined;
    format?: string | undefined;
    file?: any;
    key?: string | undefined;
    enabled?: boolean | undefined;
    nullable?: boolean | undefined;
}>;
/** Convert the array of parameters to an object keyed by the parameter name */
export declare const parameterArrayToObject: (params: RequestExampleParameter[]) => Record<string, string>;
/** Request examples - formerly known as instances - are "children" of requests */
export type RequestExampleParameter = z.infer<typeof requestExampleParametersSchema>;
export declare const xScalarFileValueSchema: z.ZodNullable<z.ZodObject<{
    url: z.ZodString;
    base64: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    url: string;
    base64?: string | undefined;
}, {
    url: string;
    base64?: string | undefined;
}>>;
/**
 * When files are required for an example we provide the options
 * to provide a public URL or a base64 encoded string
 */
export type XScalarFileValue = z.infer<typeof xScalarFileValueSchema>;
/**
 * Schema for the OAS serialization of request example parameters
 *
 * File values can be optionally fetched on import OR inserted as a base64 encoded string
 */
export declare const xScalarFormDataValue: z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"string">;
    value: z.ZodString;
}, "strip", z.ZodTypeAny, {
    type: "string";
    value: string;
}, {
    type: "string";
    value: string;
}>, z.ZodObject<{
    type: z.ZodLiteral<"file">;
    file: z.ZodNullable<z.ZodObject<{
        url: z.ZodString;
        base64: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        base64?: string | undefined;
    }, {
        url: string;
        base64?: string | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    type: "file";
    file: {
        url: string;
        base64?: string | undefined;
    } | null;
}, {
    type: "file";
    file: {
        url: string;
        base64?: string | undefined;
    } | null;
}>]>;
export type XScalarFormDataValue = z.infer<typeof xScalarFormDataValue>;
/**
 * Possible encodings for example request bodies when using text formats
 *
 * TODO: This list may not be comprehensive enough
 */
export declare const exampleRequestBodyEncoding: readonly ["json", "text", "html", "javascript", "xml", "yaml", "edn"];
export type BodyEncoding = (typeof exampleRequestBodyEncoding)[number];
export declare const exampleBodyMime: readonly ["application/json", "text/plain", "text/html", "application/javascript", "application/xml", "application/yaml", "application/edn", "application/octet-stream", "application/x-www-form-urlencoded", "multipart/form-data", "binary"];
export type BodyMime = (typeof exampleBodyMime)[number];
/**
 * TODO: Migrate away from this layout to the format used in the extension
 *
 * If a user changes the encoding of the body we expect the content to change as well
 */
export declare const exampleRequestBodySchema: z.ZodObject<{
    raw: z.ZodOptional<z.ZodObject<{
        encoding: z.ZodEnum<["json", "text", "html", "javascript", "xml", "yaml", "edn"]>;
        value: z.ZodDefault<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        value: string;
        encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
    }, {
        encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
        value?: string | undefined;
    }>>;
    formData: z.ZodOptional<z.ZodObject<{
        encoding: z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"form-data">, z.ZodLiteral<"urlencoded">]>>;
        value: z.ZodDefault<z.ZodArray<z.ZodEffects<z.ZodObject<{
            key: z.ZodDefault<z.ZodString>;
            value: z.ZodDefault<z.ZodString>;
            enabled: z.ZodDefault<z.ZodBoolean>;
            file: z.ZodOptional<z.ZodAny>;
            description: z.ZodOptional<z.ZodString>;
            required: z.ZodOptional<z.ZodBoolean>;
            enum: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            examples: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            format: z.ZodOptional<z.ZodString>;
            minimum: z.ZodOptional<z.ZodNumber>;
            maximum: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodAny>;
            nullable: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        value: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
        encoding: "form-data" | "urlencoded";
    }, {
        value?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
        encoding?: "form-data" | "urlencoded" | undefined;
    }>>;
    binary: z.ZodOptional<z.ZodType<Blob, z.ZodTypeDef, Blob>>;
    activeBody: z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"raw">, z.ZodLiteral<"formData">, z.ZodLiteral<"binary">]>>;
}, "strip", z.ZodTypeAny, {
    activeBody: "binary" | "formData" | "raw";
    binary?: Blob | undefined;
    formData?: {
        value: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
        encoding: "form-data" | "urlencoded";
    } | undefined;
    raw?: {
        value: string;
        encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
    } | undefined;
}, {
    binary?: Blob | undefined;
    formData?: {
        value?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
        encoding?: "form-data" | "urlencoded" | undefined;
    } | undefined;
    raw?: {
        encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
        value?: string | undefined;
    } | undefined;
    activeBody?: "binary" | "formData" | "raw" | undefined;
}>;
export type ExampleRequestBody = z.infer<typeof exampleRequestBodySchema>;
/** Schema for the OAS serialization of request example bodies */
export declare const xScalarExampleBodySchema: z.ZodObject<{
    encoding: z.ZodEnum<["application/json", "text/plain", "text/html", "application/javascript", "application/xml", "application/yaml", "application/edn", "application/octet-stream", "application/x-www-form-urlencoded", "multipart/form-data", "binary"]>;
    /**
     * Body content as an object with a separately specified encoding or a simple pre-encoded string value
     *
     * Ideally we would convert any objects into the proper encoding on import
     */
    content: z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodAny>, z.ZodString]>;
    /** When the encoding is `binary` this will be used to link to the file */
    file: z.ZodOptional<z.ZodNullable<z.ZodObject<{
        url: z.ZodString;
        base64: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        base64?: string | undefined;
    }, {
        url: string;
        base64?: string | undefined;
    }>>>;
}, "strip", z.ZodTypeAny, {
    content: string | Record<string, any>;
    encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
    file?: {
        url: string;
        base64?: string | undefined;
    } | null | undefined;
}, {
    content: string | Record<string, any>;
    encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
    file?: {
        url: string;
        base64?: string | undefined;
    } | null | undefined;
}>;
export type XScalarExampleBody = z.infer<typeof xScalarExampleBodySchema>;
export declare const requestExampleSchema: z.ZodObject<{
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "example">;
    type: z.ZodDefault<z.ZodOptional<z.ZodLiteral<"requestExample">>>;
    requestUid: z.ZodOptional<z.ZodBranded<z.ZodString, "operation">>;
    name: z.ZodDefault<z.ZodOptional<z.ZodString>>;
    body: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        raw: z.ZodOptional<z.ZodObject<{
            encoding: z.ZodEnum<["json", "text", "html", "javascript", "xml", "yaml", "edn"]>;
            value: z.ZodDefault<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            value: string;
            encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
        }, {
            encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
            value?: string | undefined;
        }>>;
        formData: z.ZodOptional<z.ZodObject<{
            encoding: z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"form-data">, z.ZodLiteral<"urlencoded">]>>;
            value: z.ZodDefault<z.ZodArray<z.ZodEffects<z.ZodObject<{
                key: z.ZodDefault<z.ZodString>;
                value: z.ZodDefault<z.ZodString>;
                enabled: z.ZodDefault<z.ZodBoolean>;
                file: z.ZodOptional<z.ZodAny>;
                description: z.ZodOptional<z.ZodString>;
                required: z.ZodOptional<z.ZodBoolean>;
                enum: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                examples: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                type: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
                format: z.ZodOptional<z.ZodString>;
                minimum: z.ZodOptional<z.ZodNumber>;
                maximum: z.ZodOptional<z.ZodNumber>;
                default: z.ZodOptional<z.ZodAny>;
                nullable: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }, {
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                value?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                key?: string | undefined;
                enabled?: boolean | undefined;
                nullable?: boolean | undefined;
            }>, {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }, {
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                value?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                key?: string | undefined;
                enabled?: boolean | undefined;
                nullable?: boolean | undefined;
            }>, "many">>;
        }, "strip", z.ZodTypeAny, {
            value: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            encoding: "form-data" | "urlencoded";
        }, {
            value?: {
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                value?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                key?: string | undefined;
                enabled?: boolean | undefined;
                nullable?: boolean | undefined;
            }[] | undefined;
            encoding?: "form-data" | "urlencoded" | undefined;
        }>>;
        binary: z.ZodOptional<z.ZodType<Blob, z.ZodTypeDef, Blob>>;
        activeBody: z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"raw">, z.ZodLiteral<"formData">, z.ZodLiteral<"binary">]>>;
    }, "strip", z.ZodTypeAny, {
        activeBody: "binary" | "formData" | "raw";
        binary?: Blob | undefined;
        formData?: {
            value: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            encoding: "form-data" | "urlencoded";
        } | undefined;
        raw?: {
            value: string;
            encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
        } | undefined;
    }, {
        binary?: Blob | undefined;
        formData?: {
            value?: {
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                value?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                key?: string | undefined;
                enabled?: boolean | undefined;
                nullable?: boolean | undefined;
            }[] | undefined;
            encoding?: "form-data" | "urlencoded" | undefined;
        } | undefined;
        raw?: {
            encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
            value?: string | undefined;
        } | undefined;
        activeBody?: "binary" | "formData" | "raw" | undefined;
    }>>>;
    parameters: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        path: z.ZodDefault<z.ZodArray<z.ZodEffects<z.ZodObject<{
            key: z.ZodDefault<z.ZodString>;
            value: z.ZodDefault<z.ZodString>;
            enabled: z.ZodDefault<z.ZodBoolean>;
            file: z.ZodOptional<z.ZodAny>;
            description: z.ZodOptional<z.ZodString>;
            required: z.ZodOptional<z.ZodBoolean>;
            enum: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            examples: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            format: z.ZodOptional<z.ZodString>;
            minimum: z.ZodOptional<z.ZodNumber>;
            maximum: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodAny>;
            nullable: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, "many">>;
        query: z.ZodDefault<z.ZodArray<z.ZodEffects<z.ZodObject<{
            key: z.ZodDefault<z.ZodString>;
            value: z.ZodDefault<z.ZodString>;
            enabled: z.ZodDefault<z.ZodBoolean>;
            file: z.ZodOptional<z.ZodAny>;
            description: z.ZodOptional<z.ZodString>;
            required: z.ZodOptional<z.ZodBoolean>;
            enum: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            examples: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            format: z.ZodOptional<z.ZodString>;
            minimum: z.ZodOptional<z.ZodNumber>;
            maximum: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodAny>;
            nullable: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, "many">>;
        headers: z.ZodDefault<z.ZodArray<z.ZodEffects<z.ZodObject<{
            key: z.ZodDefault<z.ZodString>;
            value: z.ZodDefault<z.ZodString>;
            enabled: z.ZodDefault<z.ZodBoolean>;
            file: z.ZodOptional<z.ZodAny>;
            description: z.ZodOptional<z.ZodString>;
            required: z.ZodOptional<z.ZodBoolean>;
            enum: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            examples: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            format: z.ZodOptional<z.ZodString>;
            minimum: z.ZodOptional<z.ZodNumber>;
            maximum: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodAny>;
            nullable: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, "many">>;
        cookies: z.ZodDefault<z.ZodArray<z.ZodEffects<z.ZodObject<{
            key: z.ZodDefault<z.ZodString>;
            value: z.ZodDefault<z.ZodString>;
            enabled: z.ZodDefault<z.ZodBoolean>;
            file: z.ZodOptional<z.ZodAny>;
            description: z.ZodOptional<z.ZodString>;
            required: z.ZodOptional<z.ZodBoolean>;
            enum: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            examples: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            type: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodArray<z.ZodString, "many">]>>;
            format: z.ZodOptional<z.ZodString>;
            minimum: z.ZodOptional<z.ZodNumber>;
            maximum: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodAny>;
            nullable: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }, {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }>, "many">>;
    }, "strip", z.ZodTypeAny, {
        path: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
        cookies: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
        query: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
        headers: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
    }, {
        path?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
        cookies?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
        query?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
        headers?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
    }>>>;
    /** TODO: Should this be deprecated? */
    serverVariables: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodString, "many">>>;
}, "strip", z.ZodTypeAny, {
    type: "requestExample";
    uid: string & z.BRAND<"example">;
    name: string;
    parameters: {
        path: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
        cookies: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
        query: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
        headers: {
            value: string;
            key: string;
            enabled: boolean;
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            nullable?: boolean | undefined;
        }[];
    };
    body: {
        activeBody: "binary" | "formData" | "raw";
        binary?: Blob | undefined;
        formData?: {
            value: {
                value: string;
                key: string;
                enabled: boolean;
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                nullable?: boolean | undefined;
            }[];
            encoding: "form-data" | "urlencoded";
        } | undefined;
        raw?: {
            value: string;
            encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
        } | undefined;
    };
    requestUid?: (string & z.BRAND<"operation">) | undefined;
    serverVariables?: Record<string, string[]> | undefined;
}, {
    type?: "requestExample" | undefined;
    uid?: string | undefined;
    name?: string | undefined;
    parameters?: {
        path?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
        cookies?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
        query?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
        headers?: {
            minimum?: number | undefined;
            type?: string | string[] | undefined;
            maximum?: number | undefined;
            value?: string | undefined;
            default?: any;
            required?: boolean | undefined;
            description?: string | undefined;
            enum?: string[] | undefined;
            examples?: string[] | undefined;
            format?: string | undefined;
            file?: any;
            key?: string | undefined;
            enabled?: boolean | undefined;
            nullable?: boolean | undefined;
        }[] | undefined;
    } | undefined;
    body?: {
        binary?: Blob | undefined;
        formData?: {
            value?: {
                minimum?: number | undefined;
                type?: string | string[] | undefined;
                maximum?: number | undefined;
                value?: string | undefined;
                default?: any;
                required?: boolean | undefined;
                description?: string | undefined;
                enum?: string[] | undefined;
                examples?: string[] | undefined;
                format?: string | undefined;
                file?: any;
                key?: string | undefined;
                enabled?: boolean | undefined;
                nullable?: boolean | undefined;
            }[] | undefined;
            encoding?: "form-data" | "urlencoded" | undefined;
        } | undefined;
        raw?: {
            encoding: "xml" | "text" | "json" | "html" | "javascript" | "yaml" | "edn";
            value?: string | undefined;
        } | undefined;
        activeBody?: "binary" | "formData" | "raw" | undefined;
    } | undefined;
    requestUid?: string | undefined;
    serverVariables?: Record<string, string[]> | undefined;
}>;
export type RequestExample = z.infer<typeof requestExampleSchema>;
/** Schema for the OAS serialization of request examples */
export declare const xScalarExampleSchema: z.ZodObject<{
    /** TODO: Should this be required? */
    name: z.ZodOptional<z.ZodString>;
    body: z.ZodOptional<z.ZodObject<{
        encoding: z.ZodEnum<["application/json", "text/plain", "text/html", "application/javascript", "application/xml", "application/yaml", "application/edn", "application/octet-stream", "application/x-www-form-urlencoded", "multipart/form-data", "binary"]>;
        /**
         * Body content as an object with a separately specified encoding or a simple pre-encoded string value
         *
         * Ideally we would convert any objects into the proper encoding on import
         */
        content: z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodAny>, z.ZodString]>;
        /** When the encoding is `binary` this will be used to link to the file */
        file: z.ZodOptional<z.ZodNullable<z.ZodObject<{
            url: z.ZodString;
            base64: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            url: string;
            base64?: string | undefined;
        }, {
            url: string;
            base64?: string | undefined;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        content: string | Record<string, any>;
        encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
        file?: {
            url: string;
            base64?: string | undefined;
        } | null | undefined;
    }, {
        content: string | Record<string, any>;
        encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
        file?: {
            url: string;
            base64?: string | undefined;
        } | null | undefined;
    }>>;
    parameters: z.ZodObject<{
        path: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        query: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        headers: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        cookies: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        path?: Record<string, string> | undefined;
        cookies?: Record<string, string> | undefined;
        query?: Record<string, string> | undefined;
        headers?: Record<string, string> | undefined;
    }, {
        path?: Record<string, string> | undefined;
        cookies?: Record<string, string> | undefined;
        query?: Record<string, string> | undefined;
        headers?: Record<string, string> | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    parameters: {
        path?: Record<string, string> | undefined;
        cookies?: Record<string, string> | undefined;
        query?: Record<string, string> | undefined;
        headers?: Record<string, string> | undefined;
    };
    name?: string | undefined;
    body?: {
        content: string | Record<string, any>;
        encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
        file?: {
            url: string;
            base64?: string | undefined;
        } | null | undefined;
    } | undefined;
}, {
    parameters: {
        path?: Record<string, string> | undefined;
        cookies?: Record<string, string> | undefined;
        query?: Record<string, string> | undefined;
        headers?: Record<string, string> | undefined;
    };
    name?: string | undefined;
    body?: {
        content: string | Record<string, any>;
        encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
        file?: {
            url: string;
            base64?: string | undefined;
        } | null | undefined;
    } | undefined;
}>;
export type XScalarExample = z.infer<typeof xScalarExampleSchema>;
/**
 * Convert a request example to the xScalar serialized format
 *
 * TODO: The base format should be migrated to align MUCH closer to the serialized format
 */
export declare function convertExampleToXScalar(example: RequestExample): {
    parameters: {
        path?: Record<string, string> | undefined;
        cookies?: Record<string, string> | undefined;
        query?: Record<string, string> | undefined;
        headers?: Record<string, string> | undefined;
    };
    name?: string | undefined;
    body?: {
        content: string | Record<string, any>;
        encoding: "application/json" | "text/plain" | "text/html" | "application/javascript" | "application/xml" | "application/yaml" | "application/edn" | "application/octet-stream" | "application/x-www-form-urlencoded" | "multipart/form-data" | "binary";
        file?: {
            url: string;
            base64?: string | undefined;
        } | null | undefined;
    } | undefined;
};
/** Create new instance parameter from a request parameter */
export declare function createParamInstance(param: RequestParameter): {
    value: string;
    key: string;
    enabled: boolean;
    minimum?: number | undefined;
    type?: string | string[] | undefined;
    maximum?: number | undefined;
    default?: any;
    required?: boolean | undefined;
    description?: string | undefined;
    enum?: string[] | undefined;
    examples?: string[] | undefined;
    format?: string | undefined;
    file?: any;
    nullable?: boolean | undefined;
};
/**
 * Create new request example from a request
 * Iterates the name of the example if provided
 */
export declare function createExampleFromRequest(request: Request, name: string, server?: Server): RequestExample;
//# sourceMappingURL=request-examples.d.ts.map