import { z } from 'zod';
export declare const securitySchemeApiKeyIn: readonly ["query", "header", "cookie"];
export declare const securityApiKeySchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"apiKey">;
    /** REQUIRED. The name of the header, query or cookie parameter to be used. */
    name: z.ZodDefault<z.ZodOptional<z.ZodString>>;
    /** REQUIRED. The location of the API key. Valid values are "query", "header" or "cookie". */
    in: z.ZodDefault<z.ZodOptional<z.ZodEnum<["query", "header", "cookie"]>>>;
}>, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "securityScheme">;
    /** The name key that links a security requirement to a security object */
    nameKey: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, {
    value: z.ZodDefault<z.ZodString>;
}>, "strip", z.ZodTypeAny, {
    type: "apiKey";
    value: string;
    uid: string & z.BRAND<"securityScheme">;
    name: string;
    nameKey: string;
    in: "cookie" | "query" | "header";
    description?: string | undefined;
}, {
    type: "apiKey";
    value?: string | undefined;
    uid?: string | undefined;
    name?: string | undefined;
    description?: string | undefined;
    nameKey?: string | undefined;
    in?: "cookie" | "query" | "header" | undefined;
}>;
export type SecuritySchemeApiKey = z.infer<typeof securityApiKeySchema>;
export declare const securityHttpSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"http">;
    /**
     * REQUIRED. The name of the HTTP Authorization scheme to be used in the Authorization header as defined in
     * [RFC7235]. The values used SHOULD be registered in the IANA Authentication Scheme registry.
     */
    scheme: z.ZodDefault<z.ZodOptional<z.ZodPipeline<z.ZodString, z.ZodEnum<["basic", "bearer"]>>>>;
    /**
     * A hint to the client to identify how the bearer token is formatted.
     * Bearer tokens are usually generated by an authorization server, so
     * this information is primarily for documentation purposes.
     */
    bearerFormat: z.ZodDefault<z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"JWT">, z.ZodString]>>>;
}>, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "securityScheme">;
    /** The name key that links a security requirement to a security object */
    nameKey: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, {
    username: z.ZodDefault<z.ZodString>;
    password: z.ZodDefault<z.ZodString>;
    token: z.ZodDefault<z.ZodString>;
}>, "strip", z.ZodTypeAny, {
    type: "http";
    uid: string & z.BRAND<"securityScheme">;
    nameKey: string;
    scheme: "basic" | "bearer";
    bearerFormat: string;
    username: string;
    password: string;
    token: string;
    description?: string | undefined;
}, {
    type: "http";
    uid?: string | undefined;
    description?: string | undefined;
    nameKey?: string | undefined;
    scheme?: string | undefined;
    bearerFormat?: string | undefined;
    username?: string | undefined;
    password?: string | undefined;
    token?: string | undefined;
}>;
export type SecuritySchemaHttp = z.infer<typeof securityHttpSchema>;
export declare const securityOpenIdSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"openIdConnect">;
    /**
     * REQUIRED. OpenId Connect URL to discover OAuth2 configuration values. This MUST be in the
     * form of a URL. The OpenID Connect standard requires the use of TLS.
     */
    openIdConnectUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "securityScheme">;
    /** The name key that links a security requirement to a security object */
    nameKey: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, "strip", z.ZodTypeAny, {
    type: "openIdConnect";
    uid: string & z.BRAND<"securityScheme">;
    nameKey: string;
    openIdConnectUrl: string;
    description?: string | undefined;
}, {
    type: "openIdConnect";
    uid?: string | undefined;
    description?: string | undefined;
    nameKey?: string | undefined;
    openIdConnectUrl?: string | undefined;
}>;
export type SecuritySchemaOpenId = z.infer<typeof securityOpenIdSchema>;
/** Options for the x-usePkce extension */
export declare const pkceOptions: readonly ["SHA-256", "plain", "no"];
export declare const securityOauthSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"oauth2">;
    /** REQUIRED. An object containing configuration information for the flow types supported. */
    flows: z.ZodDefault<z.ZodObject<{
        implicit: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"implicit">;
            authorizationUrl: z.ZodDefault<z.ZodString>;
            'x-scalar-redirect-uri': z.ZodDefault<z.ZodOptional<z.ZodString>>;
        }>, "strip", z.ZodTypeAny, {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        }, {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        }>>;
        password: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"password">;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
            username: z.ZodDefault<z.ZodString>;
            password: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        }, {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        }>>;
        clientCredentials: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"clientCredentials">;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        }, {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        }>>;
        authorizationCode: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"authorizationCode">;
            authorizationUrl: z.ZodDefault<z.ZodString>;
            /**
             * Whether to use PKCE for the authorization code flow.
             *
             * TODO: add docs
             */
            'x-usePkce': z.ZodDefault<z.ZodOptional<z.ZodEnum<["SHA-256", "plain", "no"]>>>;
            'x-scalar-redirect-uri': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        }, {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        password?: {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        implicit?: {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        } | undefined;
    }, {
        password?: {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        implicit?: {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        } | undefined;
    }>>;
}>, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "securityScheme">;
    /** The name key that links a security requirement to a security object */
    nameKey: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, "strip", z.ZodTypeAny, {
    type: "oauth2";
    uid: string & z.BRAND<"securityScheme">;
    nameKey: string;
    flows: {
        password?: {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        implicit?: {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        } | undefined;
    };
    description?: string | undefined;
}, {
    type: "oauth2";
    uid?: string | undefined;
    description?: string | undefined;
    nameKey?: string | undefined;
    flows?: {
        password?: {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        implicit?: {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        } | undefined;
    } | undefined;
}>;
export type SecuritySchemeOauth2 = z.infer<typeof securityOauthSchema>;
export type SecuritySchemeOauth2Payload = z.input<typeof securityOauthSchema>;
export type Oauth2Flow = NonNullable<SecuritySchemeOauth2['flows']['authorizationCode' | 'clientCredentials' | 'implicit' | 'password']>;
/** Payload for the oauth 2 flows + extensions */
export type Oauth2FlowPayload = NonNullable<SecuritySchemeOauth2Payload['flows']>['authorizationCode' | 'clientCredentials' | 'implicit' | 'password'] & Record<`x-${string}`, string>;
/**
 * Security Requirement
 * Lists the required security schemes to execute this operation OR the whole collection/spec.
 * The name used for each property MUST correspond to a security scheme declared in the Security
 * Schemes under the Components Object.
 *
 * The key (name) here will be matched to the key of the securityScheme for linking
 *
 * @see https://spec.openapis.org/oas/latest.html#security-requirement-object
 */
export declare const oasSecurityRequirementSchema: z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>>;
/** OAS Compliant security schemes */
export declare const oasSecuritySchemeSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"apiKey">;
    /** REQUIRED. The name of the header, query or cookie parameter to be used. */
    name: z.ZodDefault<z.ZodOptional<z.ZodString>>;
    /** REQUIRED. The location of the API key. Valid values are "query", "header" or "cookie". */
    in: z.ZodDefault<z.ZodOptional<z.ZodEnum<["query", "header", "cookie"]>>>;
}>, "strip", z.ZodTypeAny, {
    type: "apiKey";
    name: string;
    in: "cookie" | "query" | "header";
    description?: string | undefined;
}, {
    type: "apiKey";
    name?: string | undefined;
    description?: string | undefined;
    in?: "cookie" | "query" | "header" | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"http">;
    /**
     * REQUIRED. The name of the HTTP Authorization scheme to be used in the Authorization header as defined in
     * [RFC7235]. The values used SHOULD be registered in the IANA Authentication Scheme registry.
     */
    scheme: z.ZodDefault<z.ZodOptional<z.ZodPipeline<z.ZodString, z.ZodEnum<["basic", "bearer"]>>>>;
    /**
     * A hint to the client to identify how the bearer token is formatted.
     * Bearer tokens are usually generated by an authorization server, so
     * this information is primarily for documentation purposes.
     */
    bearerFormat: z.ZodDefault<z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"JWT">, z.ZodString]>>>;
}>, "strip", z.ZodTypeAny, {
    type: "http";
    scheme: "basic" | "bearer";
    bearerFormat: string;
    description?: string | undefined;
}, {
    type: "http";
    description?: string | undefined;
    scheme?: string | undefined;
    bearerFormat?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"oauth2">;
    /** REQUIRED. An object containing configuration information for the flow types supported. */
    flows: z.ZodDefault<z.ZodObject<{
        implicit: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"implicit">;
            authorizationUrl: z.ZodDefault<z.ZodString>;
            'x-scalar-redirect-uri': z.ZodDefault<z.ZodOptional<z.ZodString>>;
        }>, "strip", z.ZodTypeAny, {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        }, {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        }>>;
        password: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"password">;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
            username: z.ZodDefault<z.ZodString>;
            password: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        }, {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        }>>;
        clientCredentials: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"clientCredentials">;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        }, {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        }>>;
        authorizationCode: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"authorizationCode">;
            authorizationUrl: z.ZodDefault<z.ZodString>;
            /**
             * Whether to use PKCE for the authorization code flow.
             *
             * TODO: add docs
             */
            'x-usePkce': z.ZodDefault<z.ZodOptional<z.ZodEnum<["SHA-256", "plain", "no"]>>>;
            'x-scalar-redirect-uri': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        }, {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        password?: {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        implicit?: {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        } | undefined;
    }, {
        password?: {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        implicit?: {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        } | undefined;
    }>>;
}>, "strip", z.ZodTypeAny, {
    type: "oauth2";
    flows: {
        password?: {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        implicit?: {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        } | undefined;
    };
    description?: string | undefined;
}, {
    type: "oauth2";
    description?: string | undefined;
    flows?: {
        password?: {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        implicit?: {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        } | undefined;
    } | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"openIdConnect">;
    /**
     * REQUIRED. OpenId Connect URL to discover OAuth2 configuration values. This MUST be in the
     * form of a URL. The OpenID Connect standard requires the use of TLS.
     */
    openIdConnectUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, "strip", z.ZodTypeAny, {
    type: "openIdConnect";
    openIdConnectUrl: string;
    description?: string | undefined;
}, {
    type: "openIdConnect";
    description?: string | undefined;
    openIdConnectUrl?: string | undefined;
}>]>;
/** Extended security schemes for workspace usage */
export declare const securitySchemeSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"apiKey">;
    /** REQUIRED. The name of the header, query or cookie parameter to be used. */
    name: z.ZodDefault<z.ZodOptional<z.ZodString>>;
    /** REQUIRED. The location of the API key. Valid values are "query", "header" or "cookie". */
    in: z.ZodDefault<z.ZodOptional<z.ZodEnum<["query", "header", "cookie"]>>>;
}>, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "securityScheme">;
    /** The name key that links a security requirement to a security object */
    nameKey: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, {
    value: z.ZodDefault<z.ZodString>;
}>, "strip", z.ZodTypeAny, {
    type: "apiKey";
    value: string;
    uid: string & z.BRAND<"securityScheme">;
    name: string;
    nameKey: string;
    in: "cookie" | "query" | "header";
    description?: string | undefined;
}, {
    type: "apiKey";
    value?: string | undefined;
    uid?: string | undefined;
    name?: string | undefined;
    description?: string | undefined;
    nameKey?: string | undefined;
    in?: "cookie" | "query" | "header" | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"http">;
    /**
     * REQUIRED. The name of the HTTP Authorization scheme to be used in the Authorization header as defined in
     * [RFC7235]. The values used SHOULD be registered in the IANA Authentication Scheme registry.
     */
    scheme: z.ZodDefault<z.ZodOptional<z.ZodPipeline<z.ZodString, z.ZodEnum<["basic", "bearer"]>>>>;
    /**
     * A hint to the client to identify how the bearer token is formatted.
     * Bearer tokens are usually generated by an authorization server, so
     * this information is primarily for documentation purposes.
     */
    bearerFormat: z.ZodDefault<z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"JWT">, z.ZodString]>>>;
}>, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "securityScheme">;
    /** The name key that links a security requirement to a security object */
    nameKey: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, {
    username: z.ZodDefault<z.ZodString>;
    password: z.ZodDefault<z.ZodString>;
    token: z.ZodDefault<z.ZodString>;
}>, "strip", z.ZodTypeAny, {
    type: "http";
    uid: string & z.BRAND<"securityScheme">;
    nameKey: string;
    scheme: "basic" | "bearer";
    bearerFormat: string;
    username: string;
    password: string;
    token: string;
    description?: string | undefined;
}, {
    type: "http";
    uid?: string | undefined;
    description?: string | undefined;
    nameKey?: string | undefined;
    scheme?: string | undefined;
    bearerFormat?: string | undefined;
    username?: string | undefined;
    password?: string | undefined;
    token?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"openIdConnect">;
    /**
     * REQUIRED. OpenId Connect URL to discover OAuth2 configuration values. This MUST be in the
     * form of a URL. The OpenID Connect standard requires the use of TLS.
     */
    openIdConnectUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "securityScheme">;
    /** The name key that links a security requirement to a security object */
    nameKey: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, "strip", z.ZodTypeAny, {
    type: "openIdConnect";
    uid: string & z.BRAND<"securityScheme">;
    nameKey: string;
    openIdConnectUrl: string;
    description?: string | undefined;
}, {
    type: "openIdConnect";
    uid?: string | undefined;
    description?: string | undefined;
    nameKey?: string | undefined;
    openIdConnectUrl?: string | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    description: z.ZodOptional<z.ZodString>;
}, {
    type: z.ZodLiteral<"oauth2">;
    /** REQUIRED. An object containing configuration information for the flow types supported. */
    flows: z.ZodDefault<z.ZodObject<{
        implicit: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"implicit">;
            authorizationUrl: z.ZodDefault<z.ZodString>;
            'x-scalar-redirect-uri': z.ZodDefault<z.ZodOptional<z.ZodString>>;
        }>, "strip", z.ZodTypeAny, {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        }, {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        }>>;
        password: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"password">;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
            username: z.ZodDefault<z.ZodString>;
            password: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        }, {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        }>>;
        clientCredentials: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"clientCredentials">;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        }, {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        }>>;
        authorizationCode: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URL to be used for obtaining refresh tokens. This MUST be in the form of a
             * URL. The OAuth2 standard requires the use of TLS.
             */
            refreshUrl: z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /**
             * REQUIRED. The available scopes for the OAuth2 security scheme. A map
             * between the scope name and a short description for it. The map MAY be empty.
             */
            scopes: z.ZodDefault<z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodString>>>>>;
            selectedScopes: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>;
            /** Extension to save the client Id associated with an oauth flow */
            'x-scalar-client-id': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            /** The auth token */
            token: z.ZodDefault<z.ZodString>;
        }, {
            type: z.ZodLiteral<"authorizationCode">;
            authorizationUrl: z.ZodDefault<z.ZodString>;
            /**
             * Whether to use PKCE for the authorization code flow.
             *
             * TODO: add docs
             */
            'x-usePkce': z.ZodDefault<z.ZodOptional<z.ZodEnum<["SHA-256", "plain", "no"]>>>;
            'x-scalar-redirect-uri': z.ZodDefault<z.ZodOptional<z.ZodString>>;
            tokenUrl: z.ZodDefault<z.ZodString>;
            clientSecret: z.ZodDefault<z.ZodString>;
        }>, "strip", z.ZodTypeAny, {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        }, {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        password?: {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        implicit?: {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        } | undefined;
    }, {
        password?: {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        implicit?: {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        } | undefined;
    }>>;
}>, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "securityScheme">;
    /** The name key that links a security requirement to a security object */
    nameKey: z.ZodDefault<z.ZodOptional<z.ZodString>>;
}>, "strip", z.ZodTypeAny, {
    type: "oauth2";
    uid: string & z.BRAND<"securityScheme">;
    nameKey: string;
    flows: {
        password?: {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        implicit?: {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            tokenUrl: string;
            clientSecret: string;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            'x-scalar-client-id': string;
            authorizationUrl: string;
            'x-scalar-redirect-uri': string;
            tokenUrl: string;
            clientSecret: string;
            'x-usePkce': "SHA-256" | "plain" | "no";
        } | undefined;
    };
    description?: string | undefined;
}, {
    type: "oauth2";
    uid?: string | undefined;
    description?: string | undefined;
    nameKey?: string | undefined;
    flows?: {
        password?: {
            type: "password";
            username?: string | undefined;
            password?: string | undefined;
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        implicit?: {
            type: "implicit";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token?: string | undefined;
            refreshUrl?: string | undefined;
            scopes?: Record<string, string | undefined> | undefined;
            selectedScopes?: string[] | undefined;
            'x-scalar-client-id'?: string | undefined;
            authorizationUrl?: string | undefined;
            'x-scalar-redirect-uri'?: string | undefined;
            tokenUrl?: string | undefined;
            clientSecret?: string | undefined;
            'x-usePkce'?: "SHA-256" | "plain" | "no" | undefined;
        } | undefined;
    } | undefined;
}>]>;
/**
 * Security Scheme Object
 *
 * @see https://spec.openapis.org/oas/latest.html#security-scheme-object
 */
export type SecurityScheme = z.infer<typeof securitySchemeSchema>;
export type SecuritySchemePayload = z.input<typeof securitySchemeSchema>;
//# sourceMappingURL=security.d.ts.map