import { themeIds } from '@scalar/themes';
import { z } from 'zod';
import { nanoidSchema } from '../shared/utility.js';
import { KEYDOWN_KEYS, HOTKEY_EVENT_NAMES } from '../hotkeys/hotkeys.js';

const modifier = z
    .enum(['Meta', 'Control', 'Shift', 'Alt', 'default'])
    .optional()
    .default('default');
const modifiers = z.array(modifier).optional().default(['default']);
const hotKeys = z.record(z.enum(KEYDOWN_KEYS), z.object({
    modifiers: modifiers.optional(),
    event: z.enum(HOTKEY_EVENT_NAMES),
}));
const hotKeyConfigSchema = z
    .object({
    modifiers,
    hotKeys: hotKeys.optional(),
})
    .optional();
const workspaceSchema = z.object({
    uid: nanoidSchema.brand(),
    name: z.string().default('Default Workspace'),
    /** Workspace description */
    description: z.string().default('Basic Scalar Workspace'),
    /** List of all collection uids in a given workspace */
    collections: z.array(z.string().brand()).default([]),
    /** List of all environment uids in a given workspace, TODO: why is this a record? */
    environments: z.record(z.string()).default({}),
    /** Customize hotkeys */
    hotKeyConfig: hotKeyConfigSchema,
    /** Active Environment ID to use for requests  */
    activeEnvironmentId: z.string().optional().default('default'),
    /** List of all cookie uids in a given workspace */
    cookies: z.array(z.string().brand()).default([]),
    /** Workspace level proxy for all requests to be sent through */
    proxyUrl: z.string().optional(),
    /** Workspace level theme, we might move this to user level later */
    themeId: z.enum(themeIds).optional().default('default'),
    /** Currently selected snippet client */
    selectedHttpClient: z
        .object({
        targetKey: z.string(),
        clientKey: z.string(),
    })
        .optional()
        .default({
        targetKey: 'shell',
        clientKey: 'curl',
    }),
});

export { workspaceSchema };
