/**
 * Type safe alternative to array.filter(Boolean)
 *
 * @example
 *
 * ```ts
 * const dataArray = [1, null, 2, undefined, 3].filter(isDefined)
 * ```
 *
 * @see https://jaketrent.com/post/typescript-type-safe-filter-boolean/
 */
const isDefined = (value) => value !== null && value !== undefined;

export { isDefined };
