/** V-2.2.0 to V-2.3.0 migration */
const migrate_v_2_3_0 = (data) => {
    console.info('Performing data migration v-2.2.0 to v-2.3.0');
    const environments = data.environments;
    const workspaces = Object.values(data.workspaces).reduce((prev, w) => {
        const workspaceEnvironments = {};
        Object.entries(environments).forEach(([envId, envData]) => {
            const parsedData = typeof envData.value === 'string'
                ? JSON.parse(envData.value)
                : envData.value;
            if (envId === 'default') {
                Object.assign(workspaceEnvironments, parsedData);
            }
        });
        prev[w.uid] = {
            ...w,
            environments: workspaceEnvironments,
        };
        return prev;
    }, {});
    const collections = Object.values(data.collections).reduce((prev, c) => {
        prev[c.uid] = {
            ...c,
            'x-scalar-environments': c['x-scalar-environments'] || {},
        };
        return prev;
    }, {});
    Object.values(workspaces).forEach((workspace) => {
        Object.entries(environments).forEach(([envKey, envData]) => {
            if (envKey !== 'default') {
                const parsedData = typeof envData.value === 'string'
                    ? JSON.parse(envData.value)
                    : envData.value;
                const envName = envData.name;
                Object.values(collections).forEach((collection) => {
                    collection['x-scalar-environments'] =
                        collection['x-scalar-environments'] || {};
                    collection['x-scalar-environments'][envName] = {
                        variables: parsedData,
                    };
                    if (workspace.activeEnvironmentId === envKey) {
                        collection['x-scalar-active-environment'] = envName ?? '';
                    }
                });
            }
        });
    });
    return {
        ...data,
        collections,
        workspaces,
    };
};

export { migrate_v_2_3_0 };
