/** V-2.4.0 to V-2.5.0 migration */
const migrate_v_2_5_0 = (data) => {
    console.info('Performing data migration v-2.4.0 to v-2.5.0');
    const cookies = Object.entries(data.cookies || {}).reduce((acc, [key, cookie]) => {
        acc[key] = {
            ...cookie,
            uid: cookie.uid,
        };
        return acc;
    }, {});
    const collections = Object.entries(data.collections || {}).reduce((acc, [key, collection]) => {
        acc[key] = {
            ...collection,
            uid: collection.uid,
            selectedSecuritySchemeUids: collection.selectedSecuritySchemeUids,
            servers: collection.servers.map((uid) => uid),
            tags: collection.tags.map((uid) => uid),
            requests: collection.requests.map((uid) => uid),
            children: collection.children.map((uid) => uid),
            selectedServerUid: collection.selectedServerUid,
        };
        return acc;
    }, {});
    const environments = Object.entries(data.environments || {}).reduce((acc, [key, environment]) => {
        acc[key] = {
            ...environment,
            uid: environment.uid,
        };
        return acc;
    }, {});
    const requests = Object.entries(data.requests || {}).reduce((acc, [key, request]) => {
        acc[key] = {
            ...request,
            uid: request.uid,
            servers: request.servers,
            selectedServerUid: request.selectedServerUid,
            examples: request.examples,
            selectedSecuritySchemeUids: request.selectedSecuritySchemeUids,
        };
        return acc;
    }, {});
    const requestExamples = Object.entries(data.requestExamples || {}).reduce((acc, [key, example]) => {
        const headers = example.parameters.headers;
        // Check if "Accept" header exists
        const hasAcceptHeader = headers.some((header) => header.key.toLowerCase() === 'accept');
        if (!hasAcceptHeader) {
            // Add "Accept" header as the first entry
            headers.unshift({ key: 'Accept', value: '*/*', enabled: true });
        }
        // Update the example with potentially modified headers
        acc[key] = {
            ...example,
            uid: example.uid,
            requestUid: example.requestUid,
            parameters: {
                ...example.parameters,
                headers,
            },
        };
        return acc;
    }, {});
    const securitySchemes = Object.entries(data.securitySchemes || {}).reduce((acc, [key, securityScheme]) => {
        acc[key] = {
            ...securityScheme,
            uid: securityScheme.uid,
        };
        return acc;
    }, {});
    const servers = Object.entries(data.servers || {}).reduce((acc, [key, server]) => {
        acc[key] = {
            ...server,
            uid: server.uid,
            variables: Object.entries(server.variables || {}).reduce((variablesAcc, [variableKey, variable]) => {
                variablesAcc[variableKey] = {
                    ...variable,
                    enum: variable.enum && variable.enum.length > 0 ? variable.enum : undefined,
                    default: variable.default ?? '',
                    description: variable.description,
                };
                return variablesAcc;
            }, {}),
        };
        return acc;
    }, {});
    const tags = Object.entries(data.tags || {}).reduce((acc, [key, tag]) => {
        acc[key] = {
            ...tag,
            uid: tag.uid,
            children: tag.children,
        };
        return acc;
    }, {});
    const workspaces = Object.entries(data.workspaces || {}).reduce((acc, [key, workspace]) => {
        acc[key] = {
            ...workspace,
            uid: workspace.uid,
            collections: workspace.collections.map((uid) => uid),
            cookies: workspace.cookies.map((uid) => uid),
            selectedHttpClient: {
                targetKey: 'shell',
                clientKey: 'curl',
            },
        };
        return acc;
    }, {});
    return {
        ...data,
        collections,
        cookies,
        environments,
        requests,
        requestExamples,
        securitySchemes,
        servers,
        tags,
        workspaces,
    };
};

export { migrate_v_2_5_0 };
