import { type Collection, type Request, type RequestExample, type SecurityScheme, type Tag } from '../entities/spec/index.js';
import type { OpenAPIV3_1 } from '@scalar/types';
type WithRequired<T, K extends keyof T> = T & {
    [P in K]-?: T[P];
};
/**
 * Convert a workspace collection into an OpenAPI document
 */
export declare function exportSpecFromWorkspace({ collection, requests, requestExamples, tags, securitySchemes, }: {
    collection: Collection;
    requests: Record<string, Request>;
    requestExamples: Record<string, RequestExample>;
    tags: Record<string, Tag>;
    securitySchemes: Record<string, SecurityScheme>;
}): WithRequired<OpenAPIV3_1.Document<{}>, "paths" | "components" | "tags">;
export {};
//# sourceMappingURL=export-spec.d.ts.map