import type { SelectedSecuritySchemeUids } from '../entities/shared/utility.js';
import { type Collection, type CollectionPayload, type Request, type RequestExample, type Server, type Tag } from '../entities/spec/index.js';
import { type SecurityScheme } from '../entities/spec/security.js';
import type { OpenAPIV3_1 } from '@scalar/openapi-types';
import type { ReferenceConfiguration } from '@scalar/types/legacy';
import type { UnknownObject } from '@scalar/types/utils';
/** Takes a string or object and parses it into an openapi spec compliant schema */
export declare const parseSchema: (spec: string | UnknownObject, { shouldLoad }?: {
    shouldLoad?: boolean | undefined;
}) => Promise<{
    /**
     * Temporary fix for the parser returning an empty array
     * TODO: remove this once the parser is fixed
     */
    schema: OpenAPIV3_1.Document;
    errors: import("@scalar/openapi-parser").ErrorObject[];
}>;
/** Converts selected security requirements to uids */
export declare const getSelectedSecuritySchemeUids: (securityRequirements: (string | string[])[], preferredSecurityNames: (string | string[])[] | undefined, securitySchemeMap: Record<string, SecurityScheme["uid"]>) => SelectedSecuritySchemeUids;
export type ImportSpecToWorkspaceArgs = Pick<CollectionPayload, 'documentUrl' | 'watchMode'> & Pick<ReferenceConfiguration, 'authentication' | 'baseServerURL' | 'servers'> & {
    /** Sets the preferred security scheme on the collection instead of the requests */
    setCollectionSecurity?: boolean;
    /** Call the load step from the parser */
    shouldLoad?: boolean;
};
/**
 * Imports an OpenAPI document and converts it to workspace entities (Collection, Request, Server, etc.)
 *
 * The imported entities maintain a close mapping to the original OpenAPI specification to enable:
 * - Bi-directional translation between spec and workspace entities
 * - Preservation of specification details and structure
 * - Accurate representation of relationships between components
 *
 * Relationships between entities are maintained through unique identifiers (UIDs) which allow:
 * - Flexible organization at different levels (workspace, collection, request)
 * - Proper linking between related components
 * - Easy lookup and reference of dependent entities
 */
export declare function importSpecToWorkspace(spec: string | UnknownObject, { authentication, baseServerURL, documentUrl, servers: configuredServers, setCollectionSecurity, shouldLoad, watchMode, }?: ImportSpecToWorkspaceArgs): Promise<{
    error: false;
    collection: Collection;
    requests: Request[];
    schema: OpenAPIV3_1.Document;
    examples: RequestExample[];
    servers: Server[];
    tags: Tag[];
    securitySchemes: SecurityScheme[];
} | {
    error: true;
    importWarnings: string[];
}>;
/**
 * Retrieves a list of servers from an OpenAPI document and converts them to a list of Server entities.
 */
export declare function getServersFromOpenApiDocument(servers: OpenAPIV3_1.ServerObject[] | undefined, { baseServerURL }?: Pick<ReferenceConfiguration, 'baseServerURL'>): Server[];
//# sourceMappingURL=import-spec.d.ts.map