import { z } from 'zod';
export declare const environmentSchema: z.ZodObject<{
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "environment">;
    name: z.ZodDefault<z.ZodOptional<z.ZodString>>;
    color: z.ZodDefault<z.ZodOptional<z.ZodString>>;
    value: z.ZodDefault<z.ZodString>;
    isDefault: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    uid: string & z.BRAND<"environment">;
    name: string;
    value: string;
    color: string;
    isDefault?: boolean | undefined;
}, {
    uid?: string | undefined;
    name?: string | undefined;
    value?: string | undefined;
    color?: string | undefined;
    isDefault?: boolean | undefined;
}>;
/** Environment */
export type Environment = z.infer<typeof environmentSchema>;
export type EnvironmentPayload = z.input<typeof environmentSchema>;
//# sourceMappingURL=environment.d.ts.map