import { z } from 'zod';
export declare const oasCollectionSchema: z.ZodObject<{
    /**
     * @deprecated
     *
     * Needs to be remove as it is not a spec property
     */
    type: z.ZodDefault<z.ZodOptional<z.ZodLiteral<"collection">>>;
    openapi: z.ZodDefault<z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"3.0.0">, z.ZodLiteral<"3.1.0">, z.ZodLiteral<"4.0.0">]>>>;
    jsonSchemaDialect: z.ZodOptional<z.ZodString>;
    info: z.ZodCatch<z.ZodEffects<z.ZodObject<{
        title: z.ZodCatch<z.ZodString>;
        summary: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        termsOfService: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        contact: z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
            name: z.ZodOptional<z.ZodString>;
            url: z.ZodCatch<z.ZodOptional<z.ZodString>>;
            email: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        }, {
            name?: string | undefined;
            url?: unknown;
            email?: unknown;
        }>, {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        }, {
            name?: string | undefined;
            url?: unknown;
            email?: unknown;
        }>>>;
        license: z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
            name: z.ZodCatch<z.ZodNullable<z.ZodOptional<z.ZodString>>>;
            identifier: z.ZodCatch<z.ZodOptional<z.ZodString>>;
            url: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        }, {
            name?: unknown;
            identifier?: unknown;
            url?: unknown;
        }>, {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        }, {
            name?: unknown;
            identifier?: unknown;
            url?: unknown;
        }>>>;
        version: z.ZodCatch<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        title: string;
        version: string;
        description?: string | undefined;
        summary?: string | undefined;
        termsOfService?: string | undefined;
        contact?: {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        } | undefined;
        license?: {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        } | undefined;
    }, {
        description?: unknown;
        title?: unknown;
        summary?: unknown;
        termsOfService?: unknown;
        contact?: unknown;
        license?: unknown;
        version?: unknown;
    }>, {
        title: string;
        version: string;
        description?: string | undefined;
        summary?: string | undefined;
        termsOfService?: string | undefined;
        contact?: {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        } | undefined;
        license?: {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        } | undefined;
    }, {
        description?: unknown;
        title?: unknown;
        summary?: unknown;
        termsOfService?: unknown;
        contact?: unknown;
        license?: unknown;
        version?: unknown;
    }>>;
    /**
     * A declaration of which security mechanisms can be used across the API. The list of
     * values includes alternative security requirement objects that can be used. Only
     * one of the security requirement objects need to be satisfied to authorize a request.
     * Individual operations can override this definition. To make security optional, an empty
     * security requirement ({}) can be included in the array.
     */
    security: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>>, "many">>>;
    externalDocs: z.ZodOptional<z.ZodEffects<z.ZodObject<{
        description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>>;
    /** TODO: Type these */
    components: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /** TODO: Type these */
    webhooks: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /** A custom icon representing the collection */
    'x-scalar-icon': z.ZodDefault<z.ZodOptional<z.ZodString>>;
    'x-scalar-active-environment': z.ZodOptional<z.ZodString>;
    'x-scalar-environments': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        description: z.ZodOptional<z.ZodString>;
        color: z.ZodOptional<z.ZodString>;
        variables: z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<{
            description: z.ZodOptional<z.ZodString>;
            default: z.ZodDefault<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            default: string;
            description?: string | undefined;
        }, {
            description?: string | undefined;
            default?: string | undefined;
        }>, z.ZodString]>>;
    }, "strip", z.ZodTypeAny, {
        variables: Record<string, string | {
            default: string;
            description?: string | undefined;
        }>;
        color?: string | undefined;
        description?: string | undefined;
    }, {
        variables: Record<string, string | {
            description?: string | undefined;
            default?: string | undefined;
        }>;
        color?: string | undefined;
        description?: string | undefined;
    }>>>;
    'x-scalar-secrets': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        description: z.ZodOptional<z.ZodString>;
        example: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        description?: string | undefined;
        example?: string | undefined;
    }, {
        description?: string | undefined;
        example?: string | undefined;
    }>>>;
}, "strip", z.ZodTypeAny, {
    type: "collection";
    openapi: string;
    info: {
        title: string;
        version: string;
        description?: string | undefined;
        summary?: string | undefined;
        termsOfService?: string | undefined;
        contact?: {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        } | undefined;
        license?: {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        } | undefined;
    };
    security: Record<string, string[]>[];
    'x-scalar-icon': string;
    externalDocs?: {
        url: string;
        description?: string | undefined;
    } | undefined;
    jsonSchemaDialect?: string | undefined;
    components?: Record<string, unknown> | undefined;
    webhooks?: Record<string, unknown> | undefined;
    'x-scalar-active-environment'?: string | undefined;
    'x-scalar-environments'?: Record<string, {
        variables: Record<string, string | {
            default: string;
            description?: string | undefined;
        }>;
        color?: string | undefined;
        description?: string | undefined;
    }> | undefined;
    'x-scalar-secrets'?: Record<string, {
        description?: string | undefined;
        example?: string | undefined;
    }> | undefined;
}, {
    type?: "collection" | undefined;
    externalDocs?: {
        url: string;
        description?: unknown;
    } | undefined;
    openapi?: string | undefined;
    jsonSchemaDialect?: string | undefined;
    info?: unknown;
    security?: Record<string, string[] | undefined>[] | undefined;
    components?: Record<string, unknown> | undefined;
    webhooks?: Record<string, unknown> | undefined;
    'x-scalar-icon'?: string | undefined;
    'x-scalar-active-environment'?: string | undefined;
    'x-scalar-environments'?: Record<string, {
        variables: Record<string, string | {
            description?: string | undefined;
            default?: string | undefined;
        }>;
        color?: string | undefined;
        description?: string | undefined;
    }> | undefined;
    'x-scalar-secrets'?: Record<string, {
        description?: string | undefined;
        example?: string | undefined;
    }> | undefined;
}>;
export declare const extendedCollectionSchema: z.ZodObject<{
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "collection">;
    /** A list of security schemes UIDs associated with the collection */
    securitySchemes: z.ZodDefault<z.ZodArray<z.ZodString, "many">>;
    /** List of currently selected security scheme UIDs, these can be overridden per request */
    selectedSecuritySchemeUids: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodBranded<z.ZodString, "securityScheme">, z.ZodArray<z.ZodBranded<z.ZodString, "securityScheme">, "many">]>, "many">>;
    /** The currently selected server */
    selectedServerUid: z.ZodOptional<z.ZodBranded<z.ZodString, "server">>;
    /** UIDs which refer to servers on the workspace base */
    servers: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "server">, "many">>;
    /** Request UIDs associated with a collection */
    requests: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "operation">, "many">>;
    /** Tag UIDs associated with the collection */
    tags: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "tag">, "many">>;
    /** List of requests without tags and top level tag "folders" */
    children: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodBranded<z.ZodString, "operation">, z.ZodBranded<z.ZodString, "tag">]>, "many">>;
    /**
     * A link to where this document is stored
     *
     * - Used for watch mode
     * - Possibly useful for Git sync down the line
     */
    documentUrl: z.ZodOptional<z.ZodString>;
    /**
     * Enables polling of OpenAPI document urls
     *
     * @remarks Only effective when `documentUrl` is set
     */
    watchMode: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    /** Keeps track of which integration is associated with the specific collection */
    integration: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    /**
     * Selected authentication will be set at the collection level instead of the request level
     *
     * @default false
     */
    useCollectionSecurity: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    /**
     * Status of the watcher from above
     *
     * @defaults to idle for all collections, doesn't mean that it can watch for changes
     */
    watchModeStatus: z.ZodDefault<z.ZodOptional<z.ZodEnum<["IDLE", "WATCHING", "ERROR"]>>>;
}, "strip", z.ZodTypeAny, {
    uid: string & z.BRAND<"collection">;
    children: ((string & z.BRAND<"tag">) | (string & z.BRAND<"operation">))[];
    securitySchemes: string[];
    selectedSecuritySchemeUids: ((string & z.BRAND<"securityScheme">) | (string & z.BRAND<"securityScheme">)[])[];
    servers: (string & z.BRAND<"server">)[];
    requests: (string & z.BRAND<"operation">)[];
    tags: (string & z.BRAND<"tag">)[];
    watchMode: boolean;
    useCollectionSecurity: boolean;
    watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
    selectedServerUid?: (string & z.BRAND<"server">) | undefined;
    documentUrl?: string | undefined;
    integration?: string | null | undefined;
}, {
    uid?: string | undefined;
    children?: string[] | undefined;
    securitySchemes?: string[] | undefined;
    selectedSecuritySchemeUids?: (string | string[])[] | undefined;
    selectedServerUid?: string | undefined;
    servers?: string[] | undefined;
    requests?: string[] | undefined;
    tags?: string[] | undefined;
    documentUrl?: string | undefined;
    watchMode?: boolean | undefined;
    integration?: string | null | undefined;
    useCollectionSecurity?: boolean | undefined;
    watchModeStatus?: "IDLE" | "WATCHING" | "ERROR" | undefined;
}>;
export declare const collectionSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * @deprecated
     *
     * Needs to be remove as it is not a spec property
     */
    type: z.ZodDefault<z.ZodOptional<z.ZodLiteral<"collection">>>;
    openapi: z.ZodDefault<z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodLiteral<"3.0.0">, z.ZodLiteral<"3.1.0">, z.ZodLiteral<"4.0.0">]>>>;
    jsonSchemaDialect: z.ZodOptional<z.ZodString>;
    info: z.ZodCatch<z.ZodEffects<z.ZodObject<{
        title: z.ZodCatch<z.ZodString>;
        summary: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        termsOfService: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        contact: z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
            name: z.ZodOptional<z.ZodString>;
            url: z.ZodCatch<z.ZodOptional<z.ZodString>>;
            email: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        }, {
            name?: string | undefined;
            url?: unknown;
            email?: unknown;
        }>, {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        }, {
            name?: string | undefined;
            url?: unknown;
            email?: unknown;
        }>>>;
        license: z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
            name: z.ZodCatch<z.ZodNullable<z.ZodOptional<z.ZodString>>>;
            identifier: z.ZodCatch<z.ZodOptional<z.ZodString>>;
            url: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        }, {
            name?: unknown;
            identifier?: unknown;
            url?: unknown;
        }>, {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        }, {
            name?: unknown;
            identifier?: unknown;
            url?: unknown;
        }>>>;
        version: z.ZodCatch<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        title: string;
        version: string;
        description?: string | undefined;
        summary?: string | undefined;
        termsOfService?: string | undefined;
        contact?: {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        } | undefined;
        license?: {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        } | undefined;
    }, {
        description?: unknown;
        title?: unknown;
        summary?: unknown;
        termsOfService?: unknown;
        contact?: unknown;
        license?: unknown;
        version?: unknown;
    }>, {
        title: string;
        version: string;
        description?: string | undefined;
        summary?: string | undefined;
        termsOfService?: string | undefined;
        contact?: {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        } | undefined;
        license?: {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        } | undefined;
    }, {
        description?: unknown;
        title?: unknown;
        summary?: unknown;
        termsOfService?: unknown;
        contact?: unknown;
        license?: unknown;
        version?: unknown;
    }>>;
    /**
     * A declaration of which security mechanisms can be used across the API. The list of
     * values includes alternative security requirement objects that can be used. Only
     * one of the security requirement objects need to be satisfied to authorize a request.
     * Individual operations can override this definition. To make security optional, an empty
     * security requirement ({}) can be included in the array.
     */
    security: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>>, "many">>>;
    externalDocs: z.ZodOptional<z.ZodEffects<z.ZodObject<{
        description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>>;
    /** TODO: Type these */
    components: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /** TODO: Type these */
    webhooks: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /** A custom icon representing the collection */
    'x-scalar-icon': z.ZodDefault<z.ZodOptional<z.ZodString>>;
    'x-scalar-active-environment': z.ZodOptional<z.ZodString>;
    'x-scalar-environments': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        description: z.ZodOptional<z.ZodString>;
        color: z.ZodOptional<z.ZodString>;
        variables: z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<{
            description: z.ZodOptional<z.ZodString>;
            default: z.ZodDefault<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            default: string;
            description?: string | undefined;
        }, {
            description?: string | undefined;
            default?: string | undefined;
        }>, z.ZodString]>>;
    }, "strip", z.ZodTypeAny, {
        variables: Record<string, string | {
            default: string;
            description?: string | undefined;
        }>;
        color?: string | undefined;
        description?: string | undefined;
    }, {
        variables: Record<string, string | {
            description?: string | undefined;
            default?: string | undefined;
        }>;
        color?: string | undefined;
        description?: string | undefined;
    }>>>;
    'x-scalar-secrets': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        description: z.ZodOptional<z.ZodString>;
        example: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        description?: string | undefined;
        example?: string | undefined;
    }, {
        description?: string | undefined;
        example?: string | undefined;
    }>>>;
}, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "collection">;
    /** A list of security schemes UIDs associated with the collection */
    securitySchemes: z.ZodDefault<z.ZodArray<z.ZodString, "many">>;
    /** List of currently selected security scheme UIDs, these can be overridden per request */
    selectedSecuritySchemeUids: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodBranded<z.ZodString, "securityScheme">, z.ZodArray<z.ZodBranded<z.ZodString, "securityScheme">, "many">]>, "many">>;
    /** The currently selected server */
    selectedServerUid: z.ZodOptional<z.ZodBranded<z.ZodString, "server">>;
    /** UIDs which refer to servers on the workspace base */
    servers: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "server">, "many">>;
    /** Request UIDs associated with a collection */
    requests: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "operation">, "many">>;
    /** Tag UIDs associated with the collection */
    tags: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "tag">, "many">>;
    /** List of requests without tags and top level tag "folders" */
    children: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodBranded<z.ZodString, "operation">, z.ZodBranded<z.ZodString, "tag">]>, "many">>;
    /**
     * A link to where this document is stored
     *
     * - Used for watch mode
     * - Possibly useful for Git sync down the line
     */
    documentUrl: z.ZodOptional<z.ZodString>;
    /**
     * Enables polling of OpenAPI document urls
     *
     * @remarks Only effective when `documentUrl` is set
     */
    watchMode: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    /** Keeps track of which integration is associated with the specific collection */
    integration: z.ZodOptional<z.ZodNullable<z.ZodString>>;
    /**
     * Selected authentication will be set at the collection level instead of the request level
     *
     * @default false
     */
    useCollectionSecurity: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    /**
     * Status of the watcher from above
     *
     * @defaults to idle for all collections, doesn't mean that it can watch for changes
     */
    watchModeStatus: z.ZodDefault<z.ZodOptional<z.ZodEnum<["IDLE", "WATCHING", "ERROR"]>>>;
}>, "strip", z.ZodTypeAny, {
    uid: string & z.BRAND<"collection">;
    type: "collection";
    children: ((string & z.BRAND<"tag">) | (string & z.BRAND<"operation">))[];
    openapi: string;
    info: {
        title: string;
        version: string;
        description?: string | undefined;
        summary?: string | undefined;
        termsOfService?: string | undefined;
        contact?: {
            name?: string | undefined;
            url?: string | undefined;
            email?: string | undefined;
        } | undefined;
        license?: {
            name?: string | null | undefined;
            identifier?: string | undefined;
            url?: string | undefined;
        } | undefined;
    };
    security: Record<string, string[]>[];
    'x-scalar-icon': string;
    securitySchemes: string[];
    selectedSecuritySchemeUids: ((string & z.BRAND<"securityScheme">) | (string & z.BRAND<"securityScheme">)[])[];
    servers: (string & z.BRAND<"server">)[];
    requests: (string & z.BRAND<"operation">)[];
    tags: (string & z.BRAND<"tag">)[];
    watchMode: boolean;
    useCollectionSecurity: boolean;
    watchModeStatus: "IDLE" | "WATCHING" | "ERROR";
    externalDocs?: {
        url: string;
        description?: string | undefined;
    } | undefined;
    jsonSchemaDialect?: string | undefined;
    components?: Record<string, unknown> | undefined;
    webhooks?: Record<string, unknown> | undefined;
    'x-scalar-active-environment'?: string | undefined;
    'x-scalar-environments'?: Record<string, {
        variables: Record<string, string | {
            default: string;
            description?: string | undefined;
        }>;
        color?: string | undefined;
        description?: string | undefined;
    }> | undefined;
    'x-scalar-secrets'?: Record<string, {
        description?: string | undefined;
        example?: string | undefined;
    }> | undefined;
    selectedServerUid?: (string & z.BRAND<"server">) | undefined;
    documentUrl?: string | undefined;
    integration?: string | null | undefined;
}, {
    uid?: string | undefined;
    type?: "collection" | undefined;
    externalDocs?: {
        url: string;
        description?: unknown;
    } | undefined;
    children?: string[] | undefined;
    openapi?: string | undefined;
    jsonSchemaDialect?: string | undefined;
    info?: unknown;
    security?: Record<string, string[] | undefined>[] | undefined;
    components?: Record<string, unknown> | undefined;
    webhooks?: Record<string, unknown> | undefined;
    'x-scalar-icon'?: string | undefined;
    'x-scalar-active-environment'?: string | undefined;
    'x-scalar-environments'?: Record<string, {
        variables: Record<string, string | {
            description?: string | undefined;
            default?: string | undefined;
        }>;
        color?: string | undefined;
        description?: string | undefined;
    }> | undefined;
    'x-scalar-secrets'?: Record<string, {
        description?: string | undefined;
        example?: string | undefined;
    }> | undefined;
    securitySchemes?: string[] | undefined;
    selectedSecuritySchemeUids?: (string | string[])[] | undefined;
    selectedServerUid?: string | undefined;
    servers?: string[] | undefined;
    requests?: string[] | undefined;
    tags?: string[] | undefined;
    documentUrl?: string | undefined;
    watchMode?: boolean | undefined;
    integration?: string | null | undefined;
    useCollectionSecurity?: boolean | undefined;
    watchModeStatus?: "IDLE" | "WATCHING" | "ERROR" | undefined;
}>;
export type Collection = z.infer<typeof collectionSchema>;
export type CollectionPayload = z.input<typeof collectionSchema>;
//# sourceMappingURL=collection.d.ts.map