import { z } from 'zod';
/**
 * License Object
 *
 * License information for the exposed API.
 *
 * @see https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.1.md#license-object
 */
export declare const oasLicenseSchema: z.ZodEffects<z.ZodObject<{
    /** REQUIRED. The license name used for the API. */
    name: z.ZodCatch<z.ZodNullable<z.ZodOptional<z.ZodString>>>;
    /** An SPDX license expression for the API. The identifier field is mutually exclusive of the url field. */
    identifier: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    /**
     * A URI for the license used for the API. This MUST be in the form of a URI. The url field is mutually exclusive of the identifier field.
     */
    url: z.ZodCatch<z.ZodOptional<z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    name?: string | null | undefined;
    identifier?: string | undefined;
    url?: string | undefined;
}, {
    name?: unknown;
    identifier?: unknown;
    url?: unknown;
}>, {
    name?: string | null | undefined;
    identifier?: string | undefined;
    url?: string | undefined;
}, {
    name?: unknown;
    identifier?: unknown;
    url?: unknown;
}>;
/**
 * Contact Object
 *
 * Contact information for the exposed API.
 *
 * @see https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.1.md#contact-object
 */
export declare const oasContactSchema: z.ZodEffects<z.ZodObject<{
    /** The identifying name of the contact person/organization. */
    name: z.ZodOptional<z.ZodString>;
    /** The URL pointing to the contact information. This MUST be in the form of a URL. */
    url: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    /** The email address of the contact person/organization. This MUST be in the form of an email address. */
    email: z.ZodCatch<z.ZodOptional<z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    name?: string | undefined;
    url?: string | undefined;
    email?: string | undefined;
}, {
    name?: string | undefined;
    url?: unknown;
    email?: unknown;
}>, {
    name?: string | undefined;
    url?: string | undefined;
    email?: string | undefined;
}, {
    name?: string | undefined;
    url?: unknown;
    email?: unknown;
}>;
/**
 * Info Object
 *
 * The object provides metadata about the API. The metadata MAY be used by the clients if needed,
 * and MAY be presented in editing or documentation generation tools for convenience.
 *
 * @see https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.1.md#info-object
 */
export declare const oasInfoSchema: z.ZodEffects<z.ZodObject<{
    /** REQUIRED. The title of the API. */
    title: z.ZodCatch<z.ZodString>;
    /** A short summary of the API. */
    summary: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    /** A description of the API. CommonMark syntax MAY be used for rich text representation. */
    description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    /** A URL to the Terms of Service for the API. This MUST be in the form of a URL. */
    termsOfService: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    /** The contact information for the exposed API. */
    contact: z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
        /** The identifying name of the contact person/organization. */
        name: z.ZodOptional<z.ZodString>;
        /** The URL pointing to the contact information. This MUST be in the form of a URL. */
        url: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        /** The email address of the contact person/organization. This MUST be in the form of an email address. */
        email: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        name?: string | undefined;
        url?: string | undefined;
        email?: string | undefined;
    }, {
        name?: string | undefined;
        url?: unknown;
        email?: unknown;
    }>, {
        name?: string | undefined;
        url?: string | undefined;
        email?: string | undefined;
    }, {
        name?: string | undefined;
        url?: unknown;
        email?: unknown;
    }>>>;
    /** The license information for the exposed API. */
    license: z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
        /** REQUIRED. The license name used for the API. */
        name: z.ZodCatch<z.ZodNullable<z.ZodOptional<z.ZodString>>>;
        /** An SPDX license expression for the API. The identifier field is mutually exclusive of the url field. */
        identifier: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        /**
         * A URI for the license used for the API. This MUST be in the form of a URI. The url field is mutually exclusive of the identifier field.
         */
        url: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        name?: string | null | undefined;
        identifier?: string | undefined;
        url?: string | undefined;
    }, {
        name?: unknown;
        identifier?: unknown;
        url?: unknown;
    }>, {
        name?: string | null | undefined;
        identifier?: string | undefined;
        url?: string | undefined;
    }, {
        name?: unknown;
        identifier?: unknown;
        url?: unknown;
    }>>>;
    /**
     * REQUIRED. The version of the OpenAPI Document (which is distinct from the OpenAPI Specification version or the
     * version of the API being described or the version of the OpenAPI Description).
     */
    version: z.ZodCatch<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    title: string;
    version: string;
    description?: string | undefined;
    summary?: string | undefined;
    termsOfService?: string | undefined;
    contact?: {
        name?: string | undefined;
        url?: string | undefined;
        email?: string | undefined;
    } | undefined;
    license?: {
        name?: string | null | undefined;
        identifier?: string | undefined;
        url?: string | undefined;
    } | undefined;
}, {
    description?: unknown;
    title?: unknown;
    summary?: unknown;
    termsOfService?: unknown;
    contact?: unknown;
    license?: unknown;
    version?: unknown;
}>, {
    title: string;
    version: string;
    description?: string | undefined;
    summary?: string | undefined;
    termsOfService?: string | undefined;
    contact?: {
        name?: string | undefined;
        url?: string | undefined;
        email?: string | undefined;
    } | undefined;
    license?: {
        name?: string | null | undefined;
        identifier?: string | undefined;
        url?: string | undefined;
    } | undefined;
}, {
    description?: unknown;
    title?: unknown;
    summary?: unknown;
    termsOfService?: unknown;
    contact?: unknown;
    license?: unknown;
    version?: unknown;
}>;
/**
 * External Documentation Object
 *
 * Allows referencing an external resource for extended documentation.
 *
 * @see https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.1.md#external-documentation-object
 */
export declare const oasExternalDocumentationSchema: z.ZodEffects<z.ZodObject<{
    /** A description of the target documentation. CommonMark syntax MAY be used for rich text representation. */
    description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    /** REQUIRED. The URL for the target documentation. This MUST be in the form of a URL. */
    url: z.ZodString;
}, "strip", z.ZodTypeAny, {
    url: string;
    description?: string | undefined;
}, {
    url: string;
    description?: unknown;
}>, {
    url: string;
    description?: string | undefined;
}, {
    url: string;
    description?: unknown;
}>;
export type ExternalDocumentation = z.infer<typeof oasExternalDocumentationSchema>;
export declare const xScalarNestedSchema: z.ZodArray<z.ZodObject<{
    tagName: z.ZodString;
}, "strip", z.ZodTypeAny, {
    tagName: string;
}, {
    tagName: string;
}>, "many">;
/**
 * Tag Object
 *
 * Adds metadata to a single tag that is used by the Operation Object. It is not mandatory to have a Tag Object per tag
 * defined in the Operation Object instances.
 *
 * @see https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.1.1.md#tag-object
 */
export declare const oasTagSchema: z.ZodObject<{
    /**
     * @deprecated Needs to be remove as it is not a spec property
     */
    type: z.ZodDefault<z.ZodOptional<z.ZodLiteral<"tag">>>;
    /** REQUIRED. The name of the tag. */
    name: z.ZodString;
    /** A description for the tag. CommonMark syntax MAY be used for rich text representation. */
    description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    /** Additional external documentation for this tag. */
    externalDocs: z.ZodOptional<z.ZodEffects<z.ZodObject<{
        /** A description of the target documentation. CommonMark syntax MAY be used for rich text representation. */
        description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        /** REQUIRED. The URL for the target documentation. This MUST be in the form of a URL. */
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>>;
    'x-scalar-children': z.ZodOptional<z.ZodDefault<z.ZodArray<z.ZodObject<{
        tagName: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        tagName: string;
    }, {
        tagName: string;
    }>, "many">>>;
    /** Hide collections */
    'x-internal': z.ZodOptional<z.ZodBoolean>;
    'x-scalar-ignore': z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    name: string;
    type: "tag";
    description?: string | undefined;
    externalDocs?: {
        url: string;
        description?: string | undefined;
    } | undefined;
    'x-scalar-children'?: {
        tagName: string;
    }[] | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
}, {
    name: string;
    type?: "tag" | undefined;
    description?: unknown;
    externalDocs?: {
        url: string;
        description?: unknown;
    } | undefined;
    'x-scalar-children'?: {
        tagName: string;
    }[] | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
}>;
export declare const tagSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * @deprecated Needs to be remove as it is not a spec property
     */
    type: z.ZodDefault<z.ZodOptional<z.ZodLiteral<"tag">>>;
    /** REQUIRED. The name of the tag. */
    name: z.ZodString;
    /** A description for the tag. CommonMark syntax MAY be used for rich text representation. */
    description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    /** Additional external documentation for this tag. */
    externalDocs: z.ZodOptional<z.ZodEffects<z.ZodObject<{
        /** A description of the target documentation. CommonMark syntax MAY be used for rich text representation. */
        description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        /** REQUIRED. The URL for the target documentation. This MUST be in the form of a URL. */
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>>;
    'x-scalar-children': z.ZodOptional<z.ZodDefault<z.ZodArray<z.ZodObject<{
        tagName: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        tagName: string;
    }, {
        tagName: string;
    }>, "many">>>;
    /** Hide collections */
    'x-internal': z.ZodOptional<z.ZodBoolean>;
    'x-scalar-ignore': z.ZodOptional<z.ZodBoolean>;
}, {
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "tag">;
    children: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodBranded<z.ZodString, "operation">, z.ZodBranded<z.ZodString, "tag">]>, "many">>;
}>, "strip", z.ZodTypeAny, {
    uid: string & z.BRAND<"tag">;
    name: string;
    type: "tag";
    children: ((string & z.BRAND<"tag">) | (string & z.BRAND<"operation">))[];
    description?: string | undefined;
    externalDocs?: {
        url: string;
        description?: string | undefined;
    } | undefined;
    'x-scalar-children'?: {
        tagName: string;
    }[] | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
}, {
    name: string;
    uid?: string | undefined;
    type?: "tag" | undefined;
    description?: unknown;
    externalDocs?: {
        url: string;
        description?: unknown;
    } | undefined;
    'x-scalar-children'?: {
        tagName: string;
    }[] | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    children?: string[] | undefined;
}>;
export type Tag = z.infer<typeof tagSchema>;
export type TagPayload = z.input<typeof tagSchema>;
//# sourceMappingURL=spec-objects.d.ts.map