import type { ContentType } from '@scalar/types/legacy';
/**
 * Remove charset from content types
 *
 * Example: `application/json; charset=utf-8` -> `application/json`
 */
export declare function normalizeMimeTypeObject(content?: Record<ContentType, any>): {
    [x: `application/json${string}`]: any;
    [x: `application/xml${string}`]: any;
    [x: `text/plain${string}`]: any;
    [x: `text/html${string}`]: any;
    [x: `application/octet-stream${string}`]: any;
    [x: `application/x-www-form-urlencoded${string}`]: any;
    [x: `multipart/form-data${string}`]: any;
    [x: `*/*${string}`]: any;
    [x: `application/vnd.${string}+jsonnull`]: any;
    [x: `application/vnd.${string}+json${string}`]: any;
} | undefined;
//# sourceMappingURL=normalize-mime-type-object.d.ts.map