/** Parse a Zod */
function schemaModel(data, schema, throwError = true, errorLocation) {
    const result = schema.safeParse(data);
    if (!result.success) {
        console.group('Schema Error' + (errorLocation ? ` - ${errorLocation}` : ''));
        console.warn(JSON.stringify(result.error.format(), null, 2));
        console.log('Received: ', data);
        console.groupEnd();
    }
    if (throwError && !result.success) {
        throw new Error('Zod validation failure');
    }
    return result.data;
}

export { schemaModel };
