import { DATA_VERSION_LS_LEY } from './data-version.js';
import { parse } from 'flatted';

/**
 * Supports pre-flatted local storage
 */
const parseLocalStorage = (lsKey) => {
    const item = localStorage.getItem(lsKey) || '[{}]';
    const data = item[0] === '[' ? parse(item) : JSON.parse(item);
    return data;
};
/** Take a best guess of the localStorage version */
const getLocalStorageVersion = () => {
    const collectionStr = localStorage.getItem('collection');
    const dataVersion = localStorage.getItem(DATA_VERSION_LS_LEY);
    if (dataVersion) {
        return dataVersion;
    }
    // No flatted means first version
    if (!collectionStr?.length || collectionStr?.[0] === '{') {
        return '0.0.0';
    }
    // Flatted + types means > 2.1.0 but we should have a data version
    try {
        const [collection] = Object.values(parse(collectionStr) ?? {});
        if (collection?.type === 'collection') {
            return '2.1.0';
        }
        return '0.0.0';
    }
    catch (e) {
        console.error(e);
        return '0.0.0';
    }
};

export { getLocalStorageVersion, parseLocalStorage };
