/**
 * This function takes an OpenAPI schema and generates an example from it
 */
export declare const getExampleFromSchema: (schema: Record<string, any>, options?: {
    /**
     * The fallback string for empty string values.
     * @default ''
     */
    emptyString?: string;
    /**
     * Whether to use the XML tag names as keys
     * @default false
     */
    xml?: boolean;
    /**
     * Whether to show read-only/write-only properties. Otherwise all properties are shown.
     * @default undefined
     */
    mode?: "read" | "write";
    /**
     * Dynamic values to add to the example.
     */
    variables?: Record<string, any>;
    /**
     * Whether to omit empty and optional properties.
     * @default false
     */
    omitEmptyAndOptionalProperties?: boolean;
}, level?: number, parentSchema?: Record<string, any>, name?: string) => any;
//# sourceMappingURL=get-example-from-schema.d.ts.map