/**
 * Aliases Request to Operation which is closer to the spec,
 * also will not conflict with the builtin Request class
 */
import { type RequestPayload, type Request as RequestType } from './requests.js';
export type Operation = RequestType;
export type OperationPayload = RequestPayload;
export declare const operationSchema: import("zod").ZodObject<import("zod").objectUtil.extendShape<import("zod").objectUtil.extendShape<import("zod").objectUtil.extendShape<import("zod").objectUtil.extendShape<Omit<{
    tags: import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodString, "many">>;
    summary: import("zod").ZodOptional<import("zod").ZodString>;
    description: import("zod").ZodOptional<import("zod").ZodString>;
    operationId: import("zod").ZodOptional<import("zod").ZodString>;
    security: import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodString, "many">>>>, "many">>;
    requestBody: import("zod").ZodOptional<import("zod").ZodAny>;
    parameters: import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodObject<{
        in: import("zod").ZodEnum<["path", "query", "header", "cookie"]>;
        name: import("zod").ZodString;
        description: import("zod").ZodOptional<import("zod").ZodString>;
        required: import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodBoolean>>;
        deprecated: import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodBoolean>>;
        schema: import("zod").ZodOptional<import("zod").ZodUnknown>;
        content: import("zod").ZodOptional<import("zod").ZodUnknown>;
        style: import("zod").ZodOptional<import("zod").ZodEnum<["matrix", "simple", "form", "label", "spaceDelimited", "pipeDelimited", "deepObject"]>>;
        explode: import("zod").ZodOptional<import("zod").ZodBoolean>;
        example: import("zod").ZodOptional<import("zod").ZodUnknown>;
        examples: import("zod").ZodOptional<import("zod").ZodUnion<[import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodObject<{
            value: import("zod").ZodOptional<import("zod").ZodUnknown>;
            summary: import("zod").ZodOptional<import("zod").ZodString>;
            externalValue: import("zod").ZodOptional<import("zod").ZodString>;
        }, "strip", import("zod").ZodTypeAny, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }>>, import("zod").ZodArray<import("zod").ZodUnknown, "many">]>>;
    }, "strip", import("zod").ZodTypeAny, {
        name: string;
        required: boolean;
        deprecated: boolean;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        example?: unknown;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }, {
        name: string;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        required?: boolean | undefined;
        example?: unknown;
        deprecated?: boolean | undefined;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }>, "many">>;
    externalDocs: import("zod").ZodOptional<import("zod").ZodEffects<import("zod").ZodObject<{
        description: import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodString>>;
        url: import("zod").ZodString;
    }, "strip", import("zod").ZodTypeAny, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>>;
    deprecated: import("zod").ZodOptional<import("zod").ZodBoolean>;
    responses: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodAny>>;
    callbacks: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodAny>>>>;
    'x-scalar-examples': import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodObject<{
        name: import("zod").ZodOptional<import("zod").ZodString>;
        body: import("zod").ZodOptional<import("zod").ZodObject<{
            encoding: import("zod").ZodEnum<["application/json", "text/plain", "text/html", "application/javascript", "application/xml", "application/yaml", "application/edn", "application/octet-stream", "application/x-www-form-urlencoded", "multipart/form-data", "binary"]>;
            content: import("zod").ZodUnion<[import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodAny>, import("zod").ZodString]>;
            file: import("zod").ZodOptional<import("zod").ZodNullable<import("zod").ZodObject<{
                url: import("zod").ZodString;
                base64: import("zod").ZodOptional<import("zod").ZodString>;
            }, "strip", import("zod").ZodTypeAny, {
                url: string;
                base64?: string | undefined;
            }, {
                url: string;
                base64?: string | undefined;
            }>>>;
        }, "strip", import("zod").ZodTypeAny, {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        }, {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        }>>;
        parameters: import("zod").ZodObject<{
            path: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodString>>;
            query: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodString>>;
            headers: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodString>>;
            cookies: import("zod").ZodOptional<import("zod").ZodRecord<import("zod").ZodString, import("zod").ZodString>>;
        }, "strip", import("zod").ZodTypeAny, {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        }, {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        }>;
    }, "strip", import("zod").ZodTypeAny, {
        parameters: {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }, {
        parameters: {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }>>>;
    'x-internal': import("zod").ZodOptional<import("zod").ZodBoolean>;
    'x-scalar-ignore': import("zod").ZodOptional<import("zod").ZodBoolean>;
}, "x-scalar-examples">, {
    'x-codeSamples': import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodObject<{
        lang: import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodString>>;
        label: import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodString>>;
        source: import("zod").ZodString;
    }, "strip", import("zod").ZodTypeAny, {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }, {
        source: string;
        label?: unknown;
        lang?: unknown;
    }>, "many">>>;
    'x-code-samples': import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodObject<{
        lang: import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodString>>;
        label: import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodString>>;
        source: import("zod").ZodString;
    }, "strip", import("zod").ZodTypeAny, {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }, {
        source: string;
        label?: unknown;
        lang?: unknown;
    }>, "many">>>;
    'x-custom-examples': import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodArray<import("zod").ZodObject<{
        lang: import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodString>>;
        label: import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodString>>;
        source: import("zod").ZodString;
    }, "strip", import("zod").ZodTypeAny, {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }, {
        source: string;
        label?: unknown;
        lang?: unknown;
    }>, "many">>>;
}>, {
    'x-scalar-stability': import("zod").ZodCatch<import("zod").ZodOptional<import("zod").ZodEnum<[import("@scalar/types").XScalarStability.Deprecated, import("@scalar/types").XScalarStability.Experimental, import("@scalar/types").XScalarStability.Stable]>>>;
}>, {
    type: import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodLiteral<"request">>>;
    uid: import("zod").ZodBranded<import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodString>>, "operation">;
    path: import("zod").ZodDefault<import("zod").ZodOptional<import("zod").ZodString>>;
    method: import("zod").ZodDefault<import("zod").ZodEnum<["connect", "delete", "get", "head", "options", "patch", "post", "put", "trace"]>>;
    servers: import("zod").ZodDefault<import("zod").ZodArray<import("zod").ZodBranded<import("zod").ZodString, "server">, "many">>;
    selectedServerUid: import("zod").ZodDefault<import("zod").ZodNullable<import("zod").ZodOptional<import("zod").ZodBranded<import("zod").ZodString, "server">>>>;
    examples: import("zod").ZodDefault<import("zod").ZodArray<import("zod").ZodBranded<import("zod").ZodString, "example">, "many">>;
    selectedSecuritySchemeUids: import("zod").ZodDefault<import("zod").ZodArray<import("zod").ZodUnion<[import("zod").ZodBranded<import("zod").ZodString, "securityScheme">, import("zod").ZodArray<import("zod").ZodBranded<import("zod").ZodString, "securityScheme">, "many">]>, "many">>;
}>, {
    'x-post-response': import("zod").ZodOptional<import("zod").ZodString>;
}>, "strip", import("zod").ZodTypeAny, {
    uid: string & import("zod").BRAND<"operation">;
    path: string;
    type: "request";
    selectedSecuritySchemeUids: ((string & import("zod").BRAND<"securityScheme">) | (string & import("zod").BRAND<"securityScheme">)[])[];
    selectedServerUid: (string & import("zod").BRAND<"server">) | null;
    servers: (string & import("zod").BRAND<"server">)[];
    examples: (string & import("zod").BRAND<"example">)[];
    method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
    description?: string | undefined;
    summary?: string | undefined;
    externalDocs?: {
        url: string;
        description?: string | undefined;
    } | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    security?: Record<string, string[]>[] | undefined;
    tags?: string[] | undefined;
    deprecated?: boolean | undefined;
    operationId?: string | undefined;
    parameters?: {
        name: string;
        required: boolean;
        deprecated: boolean;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        example?: unknown;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }[] | undefined;
    requestBody?: any;
    responses?: Record<string, any> | undefined;
    callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
    'x-scalar-stability'?: import("@scalar/types").XScalarStability | undefined;
    'x-post-response'?: string | undefined;
    'x-codeSamples'?: {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }[] | undefined;
    'x-code-samples'?: {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }[] | undefined;
    'x-custom-examples'?: {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }[] | undefined;
}, {
    uid?: string | undefined;
    path?: string | undefined;
    type?: "request" | undefined;
    description?: string | undefined;
    summary?: string | undefined;
    externalDocs?: {
        url: string;
        description?: unknown;
    } | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    security?: Record<string, string[] | undefined>[] | undefined;
    selectedSecuritySchemeUids?: (string | string[])[] | undefined;
    selectedServerUid?: string | null | undefined;
    servers?: string[] | undefined;
    tags?: string[] | undefined;
    deprecated?: boolean | undefined;
    examples?: string[] | undefined;
    operationId?: string | undefined;
    parameters?: {
        name: string;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        required?: boolean | undefined;
        example?: unknown;
        deprecated?: boolean | undefined;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }[] | undefined;
    requestBody?: any;
    responses?: Record<string, any> | undefined;
    callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
    'x-scalar-stability'?: unknown;
    method?: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace" | undefined;
    'x-post-response'?: string | undefined;
    'x-codeSamples'?: unknown;
    'x-code-samples'?: unknown;
    'x-custom-examples'?: unknown;
}>;
//# sourceMappingURL=operation.d.ts.map