import { z } from 'zod';
import type { OpenAPIV3_1 } from '@scalar/openapi-types';
import type { RequestExampleParameter } from './request-examples.js';
export declare const parameterTypeSchema: z.ZodEnum<["path", "query", "header", "cookie"]>;
export type ParamType = z.infer<typeof parameterTypeSchema>;
export declare const parameterStyleSchema: z.ZodEnum<["matrix", "simple", "form", "label", "spaceDelimited", "pipeDelimited", "deepObject"]>;
export type ParameterStyle = z.infer<typeof parameterStyleSchema>;
export type ParameterContent = Record<string, {
    schema?: OpenAPIV3_1.Document;
    examples?: Record<string, RequestExampleParameter>;
    example?: RequestExampleParameter;
}>;
export declare const parameterExampleSchema: z.ZodUnknown;
/**
 * OpenAPI compliant parameters object
 */
export declare const oasParameterSchema: z.ZodObject<{
    in: z.ZodEnum<["path", "query", "header", "cookie"]>;
    name: z.ZodString;
    description: z.ZodOptional<z.ZodString>;
    /** Defaulted to false */
    required: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    /** Defaulted to false */
    deprecated: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
    schema: z.ZodOptional<z.ZodUnknown>;
    content: z.ZodOptional<z.ZodUnknown>;
    /** Defaulted according to @url https://spec.openapis.org/oas/v3.1.0#parameter-object */
    style: z.ZodOptional<z.ZodEnum<["matrix", "simple", "form", "label", "spaceDelimited", "pipeDelimited", "deepObject"]>>;
    explode: z.ZodOptional<z.ZodBoolean>;
    example: z.ZodOptional<z.ZodUnknown>;
    examples: z.ZodOptional<z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodObject<{
        value: z.ZodOptional<z.ZodUnknown>;
        summary: z.ZodOptional<z.ZodString>;
        externalValue: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        value?: unknown;
        summary?: string | undefined;
        externalValue?: string | undefined;
    }, {
        value?: unknown;
        summary?: string | undefined;
        externalValue?: string | undefined;
    }>>, z.ZodArray<z.ZodUnknown, "many">]>>;
}, "strip", z.ZodTypeAny, {
    name: string;
    required: boolean;
    deprecated: boolean;
    in: "cookie" | "path" | "query" | "header";
    description?: string | undefined;
    example?: unknown;
    examples?: unknown[] | Record<string, {
        value?: unknown;
        summary?: string | undefined;
        externalValue?: string | undefined;
    }> | undefined;
    schema?: unknown;
    content?: unknown;
    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
    explode?: boolean | undefined;
}, {
    name: string;
    in: "cookie" | "path" | "query" | "header";
    description?: string | undefined;
    required?: boolean | undefined;
    example?: unknown;
    deprecated?: boolean | undefined;
    examples?: unknown[] | Record<string, {
        value?: unknown;
        summary?: string | undefined;
        externalValue?: string | undefined;
    }> | undefined;
    schema?: unknown;
    content?: unknown;
    style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
    explode?: boolean | undefined;
}>;
export type RequestParameter = z.infer<typeof oasParameterSchema>;
export type RequestParameterPayload = z.input<typeof oasParameterSchema>;
//# sourceMappingURL=parameters.d.ts.map