import { z } from "zod";
const parameterTypeSchema = z.enum(["path", "query", "header", "cookie"]);
const parameterStyleSchema = z.enum([
  "matrix",
  "simple",
  "form",
  "label",
  "spaceDelimited",
  "pipeDelimited",
  "deepObject"
]);
const parameterExampleSchema = z.unknown();
const oasParameterSchema = z.object({
  in: parameterTypeSchema,
  name: z.string(),
  description: z.string().optional(),
  /** Defaulted to false */
  required: z.boolean().optional().default(false),
  /** Defaulted to false */
  deprecated: z.boolean().optional().default(false),
  schema: z.unknown().optional(),
  content: z.unknown().optional(),
  /** Defaulted according to @url https://spec.openapis.org/oas/v3.1.0#parameter-object */
  style: parameterStyleSchema.optional(),
  explode: z.boolean().optional(),
  example: z.unknown().optional(),
  examples: z.union([
    z.record(
      z.string(),
      z.object({
        value: z.unknown().optional(),
        summary: z.string().optional(),
        externalValue: z.string().optional()
      })
    ),
    z.array(z.unknown())
  ]).optional()
});
export {
  oasParameterSchema,
  parameterExampleSchema,
  parameterStyleSchema,
  parameterTypeSchema
};
//# sourceMappingURL=parameters.js.map
