import { z } from 'zod';
import { type PostResponseSchema, XPostResponseSchema } from '@scalar/openapi-types/schemas/extensions';
import { XScalarStability } from '@scalar/types';
import { type RequestExample } from './request-examples.js';
export declare const requestMethods: readonly ["connect", "delete", "get", "head", "options", "patch", "post", "put", "trace"];
export type RequestMethod = (typeof requestMethods)[number];
/** A single set of populated values for a sent request */
export type ResponseInstance = Omit<Response, 'headers'> & {
    /** Store headers as an object to match what we had with axios */
    headers: Record<string, string>;
    /** Keys of headers which set cookies */
    cookieHeaderKeys: string[];
    /** Time in ms the request took */
    duration: number;
    /** The response status */
    status: number;
    /** The response status text */
    statusText: string;
    /** The response method */
    method: RequestMethod;
    /** The request path */
    path: string;
} & ({
    /** The response data */
    data: string | Blob;
    /** The response size in bytes */
    size: number;
} | {
    /** A stream reader for a streamable response body */
    reader: ReadableStreamDefaultReader<Uint8Array>;
});
/** A single request/response set to save to the history stack */
export type RequestEvent = {
    request: RequestExample;
    response: ResponseInstance;
    timestamp: number;
};
/** Open API Compliant Request Validator */
export declare const oasRequestSchema: z.ZodObject<{
    /**
     * A list of tags for API documentation control. Tags can be used for logical
     * grouping of operations by resources or any other qualifier.
     *
     * These tags are the openapi spec tag names, not uids
     */
    tags: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    /** A short summary of what the operation does. */
    summary: z.ZodOptional<z.ZodString>;
    /** A verbose explanation of the operation behavior. CommonMark syntax MAY be used for rich text representation. */
    description: z.ZodOptional<z.ZodString>;
    /**
     * Unique string used to identify the operation. The id MUST be unique among all operations described in the API.
     * The operationId value is case-sensitive. Tools and libraries MAY use the operationId to uniquely identify an
     * operation, therefore, it is RECOMMENDED to follow bin common programming naming conventions./
     */
    operationId: z.ZodOptional<z.ZodString>;
    /**
     * A declaration of which security mechanisms can be used across the API. The list of
     * values includes alternative security requirement objects that can be used. Only
     * one of the security requirement objects need to be satisfied to authorize a request.
     * Individual operations can override this definition. To make security optional, an empty
     * security requirement ({}) can be included in the array.
     */
    security: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>>, "many">>;
    /**
     * The request body applicable for this operation. The requestBody is fully supported in HTTP methods where the
     * HTTP 1.1 specification [RFC7231] has explicitly defined semantics for request bodies. In other cases where the
     * HTTP spec is vague (such as GET, HEAD and DELETE), requestBody is permitted but does not have well-defined
     * semantics and SHOULD be avoided if possible.
     */
    requestBody: z.ZodOptional<z.ZodAny>;
    /**
     * Request parameters
     */
    parameters: z.ZodOptional<z.ZodArray<z.ZodObject<{
        in: z.ZodEnum<["path", "query", "header", "cookie"]>;
        name: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        required: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        deprecated: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        schema: z.ZodOptional<z.ZodUnknown>;
        content: z.ZodOptional<z.ZodUnknown>;
        style: z.ZodOptional<z.ZodEnum<["matrix", "simple", "form", "label", "spaceDelimited", "pipeDelimited", "deepObject"]>>;
        explode: z.ZodOptional<z.ZodBoolean>;
        example: z.ZodOptional<z.ZodUnknown>;
        examples: z.ZodOptional<z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodObject<{
            value: z.ZodOptional<z.ZodUnknown>;
            summary: z.ZodOptional<z.ZodString>;
            externalValue: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }>>, z.ZodArray<z.ZodUnknown, "many">]>>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        required: boolean;
        deprecated: boolean;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        example?: unknown;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }, {
        name: string;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        required?: boolean | undefined;
        example?: unknown;
        deprecated?: boolean | undefined;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }>, "many">>;
    /**
     * External documentation object
     */
    externalDocs: z.ZodOptional<z.ZodEffects<z.ZodObject<{
        description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>>;
    deprecated: z.ZodOptional<z.ZodBoolean>;
    /** Response formats */
    responses: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    /** Callbacks */
    callbacks: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodAny>>>>;
    /** xScalar examples */
    'x-scalar-examples': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        name: z.ZodOptional<z.ZodString>;
        body: z.ZodOptional<z.ZodObject<{
            encoding: z.ZodEnum<["application/json", "text/plain", "text/html", "application/javascript", "application/xml", "application/yaml", "application/edn", "application/octet-stream", "application/x-www-form-urlencoded", "multipart/form-data", "binary"]>;
            content: z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodAny>, z.ZodString]>;
            file: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                url: z.ZodString;
                base64: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                url: string;
                base64?: string | undefined;
            }, {
                url: string;
                base64?: string | undefined;
            }>>>;
        }, "strip", z.ZodTypeAny, {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        }, {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        }>>;
        parameters: z.ZodObject<{
            path: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            query: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            headers: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            cookies: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        }, {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        parameters: {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }, {
        parameters: {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }>>>;
    /** Hide operations */
    'x-internal': z.ZodOptional<z.ZodBoolean>;
    /** Ignore operations */
    'x-scalar-ignore': z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    description?: string | undefined;
    summary?: string | undefined;
    externalDocs?: {
        url: string;
        description?: string | undefined;
    } | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    security?: Record<string, string[]>[] | undefined;
    tags?: string[] | undefined;
    deprecated?: boolean | undefined;
    operationId?: string | undefined;
    parameters?: {
        name: string;
        required: boolean;
        deprecated: boolean;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        example?: unknown;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }[] | undefined;
    requestBody?: any;
    responses?: Record<string, any> | undefined;
    callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
    'x-scalar-examples'?: Record<string, {
        parameters: {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }> | undefined;
}, {
    description?: string | undefined;
    summary?: string | undefined;
    externalDocs?: {
        url: string;
        description?: unknown;
    } | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    security?: Record<string, string[] | undefined>[] | undefined;
    tags?: string[] | undefined;
    deprecated?: boolean | undefined;
    operationId?: string | undefined;
    parameters?: {
        name: string;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        required?: boolean | undefined;
        example?: unknown;
        deprecated?: boolean | undefined;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }[] | undefined;
    requestBody?: any;
    responses?: Record<string, any> | undefined;
    callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
    'x-scalar-examples'?: Record<string, {
        parameters: {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }> | undefined;
}>;
export type PostResponseScript = z.infer<typeof PostResponseSchema>;
export type PostResponseScripts = z.infer<typeof XPostResponseSchema>['x-post-response'];
/** Unified request schema for client usage */
export declare const requestSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<Omit<{
    /**
     * A list of tags for API documentation control. Tags can be used for logical
     * grouping of operations by resources or any other qualifier.
     *
     * These tags are the openapi spec tag names, not uids
     */
    tags: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    /** A short summary of what the operation does. */
    summary: z.ZodOptional<z.ZodString>;
    /** A verbose explanation of the operation behavior. CommonMark syntax MAY be used for rich text representation. */
    description: z.ZodOptional<z.ZodString>;
    /**
     * Unique string used to identify the operation. The id MUST be unique among all operations described in the API.
     * The operationId value is case-sensitive. Tools and libraries MAY use the operationId to uniquely identify an
     * operation, therefore, it is RECOMMENDED to follow bin common programming naming conventions./
     */
    operationId: z.ZodOptional<z.ZodString>;
    /**
     * A declaration of which security mechanisms can be used across the API. The list of
     * values includes alternative security requirement objects that can be used. Only
     * one of the security requirement objects need to be satisfied to authorize a request.
     * Individual operations can override this definition. To make security optional, an empty
     * security requirement ({}) can be included in the array.
     */
    security: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodString, "many">>>>, "many">>;
    /**
     * The request body applicable for this operation. The requestBody is fully supported in HTTP methods where the
     * HTTP 1.1 specification [RFC7231] has explicitly defined semantics for request bodies. In other cases where the
     * HTTP spec is vague (such as GET, HEAD and DELETE), requestBody is permitted but does not have well-defined
     * semantics and SHOULD be avoided if possible.
     */
    requestBody: z.ZodOptional<z.ZodAny>;
    /**
     * Request parameters
     */
    parameters: z.ZodOptional<z.ZodArray<z.ZodObject<{
        in: z.ZodEnum<["path", "query", "header", "cookie"]>;
        name: z.ZodString;
        description: z.ZodOptional<z.ZodString>;
        required: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        deprecated: z.ZodDefault<z.ZodOptional<z.ZodBoolean>>;
        schema: z.ZodOptional<z.ZodUnknown>;
        content: z.ZodOptional<z.ZodUnknown>;
        style: z.ZodOptional<z.ZodEnum<["matrix", "simple", "form", "label", "spaceDelimited", "pipeDelimited", "deepObject"]>>;
        explode: z.ZodOptional<z.ZodBoolean>;
        example: z.ZodOptional<z.ZodUnknown>;
        examples: z.ZodOptional<z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodObject<{
            value: z.ZodOptional<z.ZodUnknown>;
            summary: z.ZodOptional<z.ZodString>;
            externalValue: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }>>, z.ZodArray<z.ZodUnknown, "many">]>>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        required: boolean;
        deprecated: boolean;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        example?: unknown;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }, {
        name: string;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        required?: boolean | undefined;
        example?: unknown;
        deprecated?: boolean | undefined;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }>, "many">>;
    /**
     * External documentation object
     */
    externalDocs: z.ZodOptional<z.ZodEffects<z.ZodObject<{
        description: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>, {
        url: string;
        description?: string | undefined;
    }, {
        url: string;
        description?: unknown;
    }>>;
    deprecated: z.ZodOptional<z.ZodBoolean>;
    /** Response formats */
    responses: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    /** Callbacks */
    callbacks: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodAny>>>>;
    /** xScalar examples */
    'x-scalar-examples': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodObject<{
        name: z.ZodOptional<z.ZodString>;
        body: z.ZodOptional<z.ZodObject<{
            encoding: z.ZodEnum<["application/json", "text/plain", "text/html", "application/javascript", "application/xml", "application/yaml", "application/edn", "application/octet-stream", "application/x-www-form-urlencoded", "multipart/form-data", "binary"]>;
            content: z.ZodUnion<[z.ZodRecord<z.ZodString, z.ZodAny>, z.ZodString]>;
            file: z.ZodOptional<z.ZodNullable<z.ZodObject<{
                url: z.ZodString;
                base64: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                url: string;
                base64?: string | undefined;
            }, {
                url: string;
                base64?: string | undefined;
            }>>>;
        }, "strip", z.ZodTypeAny, {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        }, {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        }>>;
        parameters: z.ZodObject<{
            path: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            query: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            headers: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
            cookies: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        }, {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        parameters: {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }, {
        parameters: {
            path?: Record<string, string> | undefined;
            query?: Record<string, string> | undefined;
            headers?: Record<string, string> | undefined;
            cookies?: Record<string, string> | undefined;
        };
        name?: string | undefined;
        body?: {
            encoding: "binary" | "application/json" | "application/octet-stream" | "application/x-www-form-urlencoded" | "application/xml" | "multipart/form-data" | "text/plain" | "text/html" | "application/javascript" | "application/yaml" | "application/edn";
            content: string | Record<string, any>;
            file?: {
                url: string;
                base64?: string | undefined;
            } | null | undefined;
        } | undefined;
    }>>>;
    /** Hide operations */
    'x-internal': z.ZodOptional<z.ZodBoolean>;
    /** Ignore operations */
    'x-scalar-ignore': z.ZodOptional<z.ZodBoolean>;
}, "x-scalar-examples">, {
    'x-codeSamples': z.ZodCatch<z.ZodOptional<z.ZodArray<z.ZodObject<{
        lang: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        label: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        source: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }, {
        source: string;
        label?: unknown;
        lang?: unknown;
    }>, "many">>>;
    'x-code-samples': z.ZodCatch<z.ZodOptional<z.ZodArray /** Store headers as an object to match what we had with axios */<z.ZodObject<{
        lang: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        label: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        source: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }, {
        source: string;
        label?: unknown;
        lang?: unknown;
    }>, "many">>>;
    'x-custom-examples': z.ZodCatch<z.ZodOptional<z.ZodArray /** The response data */<z.ZodObject<{
        lang: z.ZodCatch<z.ZodOptional<z.ZodString /** The response size in bytes */>>;
        label: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        source: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }, {
        source: string;
        label?: unknown;
        lang?: unknown;
    }>, "many">>>;
}>, {
    'x-scalar-stability': z.ZodCatch<z.ZodOptional<z.ZodEnum<[XScalarStability.Deprecated, XScalarStability.Experimental, XScalarStability.Stable]>>>;
}>, {
    type: z.ZodDefault<z.ZodOptional<z.ZodLiteral<"request">>>;
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "operation">;
    /** Path Key */
    path: z.ZodDefault<z.ZodOptional<z.ZodString>>;
    /** Request Method */
    method: z.ZodDefault<z.ZodEnum<["connect", "delete", "get", "head", "options", "patch", "post", "put", "trace"]>>;
    /** List of server UIDs specific to the request */
    servers: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "server">, "many">>;
    /** The currently selected server */
    selectedServerUid: z.ZodDefault<z.ZodNullable<z.ZodOptional<z.ZodBranded<z.ZodString, "server">>>>;
    /** List of example UIDs associated with the request */
    examples: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "example">, "many">>;
    /** List of security scheme UIDs associated with the request */
    selectedSecuritySchemeUids: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodBranded<z.ZodString, "securityScheme">, z.ZodArray<z.ZodBranded<z.ZodString, "securityScheme">, "many">]>, "many">>;
}>, {
    'x-post-response': z.ZodOptional<z.ZodString>;
}>, "strip", z.ZodTypeAny, {
    uid: string & z.BRAND<"operation">;
    path: string;
    type: "request";
    selectedSecuritySchemeUids: ((string & z.BRAND<"securityScheme">) | (string & z.BRAND<"securityScheme">)[])[];
    selectedServerUid: (string & z.BRAND<"server">) | null;
    servers: (string & z.BRAND<"server">)[];
    examples: (string & z.BRAND<"example">)[];
    method: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace";
    description?: string | undefined;
    summary?: string | undefined;
    externalDocs?: {
        url: string;
        description?: string | undefined;
    } | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    security?: Record<string, string[]>[] | undefined;
    tags?: string[] | undefined;
    deprecated?: boolean | undefined;
    operationId?: string | undefined;
    parameters?: {
        name: string;
        required: boolean;
        deprecated: boolean;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        example?: unknown;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }[] | undefined;
    requestBody?: any;
    responses?: Record<string, any> | undefined;
    callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
    'x-scalar-stability'?: XScalarStability | undefined;
    'x-post-response'?: string | undefined;
    'x-codeSamples'?: {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }[] | undefined;
    'x-code-samples'?: {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }[] | undefined;
    'x-custom-examples'?: {
        source: string;
        label?: string | undefined;
        lang?: string | undefined;
    }[] | undefined;
}, {
    uid?: string | undefined;
    path?: string | undefined;
    type?: "request" | undefined;
    description?: string | undefined;
    summary?: string | undefined;
    externalDocs?: {
        url: string;
        description?: unknown;
    } | undefined;
    'x-internal'?: boolean | undefined;
    'x-scalar-ignore'?: boolean | undefined;
    security?: Record<string, string[] | undefined>[] | undefined;
    selectedSecuritySchemeUids?: (string | string[])[] | undefined;
    selectedServerUid?: string | null | undefined;
    servers?: string[] | undefined;
    tags?: string[] | undefined;
    deprecated?: boolean | undefined;
    examples?: string[] | undefined;
    operationId?: string | undefined;
    parameters?: {
        name: string;
        in: "cookie" | "path" | "query" | "header";
        description?: string | undefined;
        required?: boolean | undefined;
        example?: unknown;
        deprecated?: boolean | undefined;
        examples?: unknown[] | Record<string, {
            value?: unknown;
            summary?: string | undefined;
            externalValue?: string | undefined;
        }> | undefined;
        schema?: unknown;
        content?: unknown;
        style?: "matrix" | "simple" | "form" | "label" | "spaceDelimited" | "pipeDelimited" | "deepObject" | undefined;
        explode?: boolean | undefined;
    }[] | undefined;
    requestBody?: any;
    responses?: Record<string, any> | undefined;
    callbacks?: Record<string, Record<string, Record<string, any>>> | undefined;
    'x-scalar-stability'?: unknown;
    method?: "options" | "connect" | "delete" | "get" | "head" | "patch" | "post" | "put" | "trace" | undefined;
    'x-post-response'?: string | undefined;
    'x-codeSamples'?: unknown;
    'x-code-samples'?: unknown;
    'x-custom-examples'?: unknown;
}>;
export type Request = z.infer<typeof requestSchema>;
export type RequestPayload = z.input<typeof requestSchema>;
//# sourceMappingURL=requests.d.ts.map