import { selectedSecuritySchemeUidSchema } from "../../entities/shared/utility.js";
import { nanoidSchema } from "@scalar/types/utils";
import { z } from "zod";
import {
  XCodeSamplesSchema,
  XPostResponseSchema
} from "@scalar/openapi-types/schemas/extensions";
import { XScalarStability } from "@scalar/types";
import { oasSecurityRequirementSchema } from "@scalar/types/entities";
import { oasParameterSchema } from "./parameters.js";
import { xScalarExampleSchema } from "./request-examples.js";
import { oasExternalDocumentationSchema } from "./spec-objects.js";
const requestMethods = ["connect", "delete", "get", "head", "options", "patch", "post", "put", "trace"];
const requestBodySchema = z.any();
const oasRequestSchema = z.object({
  /**
   * A list of tags for API documentation control. Tags can be used for logical
   * grouping of operations by resources or any other qualifier.
   *
   * These tags are the openapi spec tag names, not uids
   */
  "tags": z.string().array().optional(),
  /** A short summary of what the operation does. */
  "summary": z.string().optional(),
  /** A verbose explanation of the operation behavior. CommonMark syntax MAY be used for rich text representation. */
  "description": z.string().optional(),
  /**
   * Unique string used to identify the operation. The id MUST be unique among all operations described in the API.
   * The operationId value is case-sensitive. Tools and libraries MAY use the operationId to uniquely identify an
   * operation, therefore, it is RECOMMENDED to follow bin common programming naming conventions./
   */
  "operationId": z.string().optional(),
  /**
   * A declaration of which security mechanisms can be used across the API. The list of
   * values includes alternative security requirement objects that can be used. Only
   * one of the security requirement objects need to be satisfied to authorize a request.
   * Individual operations can override this definition. To make security optional, an empty
   * security requirement ({}) can be included in the array.
   */
  "security": z.array(oasSecurityRequirementSchema).optional(),
  /**
   * The request body applicable for this operation. The requestBody is fully supported in HTTP methods where the
   * HTTP 1.1 specification [RFC7231] has explicitly defined semantics for request bodies. In other cases where the
   * HTTP spec is vague (such as GET, HEAD and DELETE), requestBody is permitted but does not have well-defined
   * semantics and SHOULD be avoided if possible.
   */
  "requestBody": requestBodySchema.optional(),
  /**
   * Request parameters
   */
  "parameters": oasParameterSchema.array().optional(),
  /**
   * External documentation object
   */
  "externalDocs": oasExternalDocumentationSchema.optional(),
  "deprecated": z.boolean().optional(),
  /** Response formats */
  "responses": z.record(z.string(), z.any()).optional(),
  /** Callbacks */
  "callbacks": z.record(z.string(), z.record(z.string(), z.record(z.string(), z.any()))).optional(),
  /** xScalar examples */
  "x-scalar-examples": z.record(z.string(), xScalarExampleSchema).optional(),
  /** Hide operations */
  "x-internal": z.boolean().optional(),
  /** Ignore operations */
  "x-scalar-ignore": z.boolean().optional()
});
const ScalarStabilitySchema = z.object({
  "x-scalar-stability": z.enum([XScalarStability.Deprecated, XScalarStability.Experimental, XScalarStability.Stable]).optional().catch(void 0)
});
const extendedRequestSchema = z.object({
  type: z.literal("request").optional().default("request"),
  uid: nanoidSchema.brand(),
  /** Path Key */
  path: z.string().optional().default(""),
  /** Request Method */
  method: z.enum(requestMethods).default("get"),
  /** List of server UIDs specific to the request */
  servers: z.string().brand().array().default([]),
  /** The currently selected server */
  selectedServerUid: z.string().brand().optional().nullable().default(null),
  /** List of example UIDs associated with the request */
  examples: z.string().brand().array().default([]),
  /** List of security scheme UIDs associated with the request */
  selectedSecuritySchemeUids: selectedSecuritySchemeUidSchema
});
const requestSchema = oasRequestSchema.omit({ "x-scalar-examples": true }).merge(XCodeSamplesSchema).merge(ScalarStabilitySchema).merge(extendedRequestSchema).merge(XPostResponseSchema);
export {
  oasRequestSchema,
  requestMethods,
  requestSchema
};
//# sourceMappingURL=requests.js.map
