import { omitUndefinedValues } from "@scalar/helpers/object/omit-undefined-values";
import { XScalarSdkInstallationSchema } from "@scalar/openapi-types/schemas/extensions";
import { nanoidSchema } from "@scalar/types/utils";
import { z } from "zod";
const oasLicenseSchema = z.object({
  /** REQUIRED. The license name used for the API. */
  name: z.string().optional().nullable().catch(null),
  /** An SPDX license expression for the API. The identifier field is mutually exclusive of the url field. */
  identifier: z.string().optional().catch(void 0),
  /**
   * A URI for the license used for the API. This MUST be in the form of a URI. The url field is mutually exclusive of the identifier field.
   */
  url: z.string().url().optional().catch(void 0)
}).transform(omitUndefinedValues);
const oasContactSchema = z.object({
  /** The identifying name of the contact person/organization. */
  name: z.string().optional(),
  /** The URL pointing to the contact information. This MUST be in the form of a URL. */
  url: z.string().url().optional().catch(void 0),
  /** The email address of the contact person/organization. This MUST be in the form of an email address. */
  email: z.string().optional().catch(void 0)
}).transform(omitUndefinedValues);
const oasInfoSchema = z.object({
  /** REQUIRED. The title of the API. */
  title: z.string().catch("API"),
  /** A short summary of the API. */
  summary: z.string().optional().catch(void 0),
  /** A description of the API. CommonMark syntax MAY be used for rich text representation. */
  description: z.string().optional().catch(void 0),
  /** A URL to the Terms of Service for the API. This MUST be in the form of a URL. */
  termsOfService: z.string().url().optional().catch(void 0),
  /** The contact information for the exposed API. */
  contact: oasContactSchema.optional().catch(void 0),
  /** The license information for the exposed API. */
  license: oasLicenseSchema.optional().catch(void 0),
  /**
   * REQUIRED. The version of the OpenAPI Document (which is distinct from the OpenAPI Specification version or the
   * version of the API being described or the version of the OpenAPI Description).
   */
  version: z.string().catch("1.0")
}).merge(XScalarSdkInstallationSchema).transform(omitUndefinedValues);
const oasExternalDocumentationSchema = z.object({
  /** A description of the target documentation. CommonMark syntax MAY be used for rich text representation. */
  description: z.string().optional().catch(void 0),
  /** REQUIRED. The URL for the target documentation. This MUST be in the form of a URL. */
  url: z.string()
}).transform(omitUndefinedValues);
const xScalarNestedSchema = z.object({
  tagName: z.string()
}).array();
const oasTagSchema = z.object({
  // TODO: Remove
  /**
   * @deprecated Needs to be remove as it is not a spec property
   */
  "type": z.literal("tag").optional().default("tag"),
  /** REQUIRED. The name of the tag. */
  "name": z.string(),
  /** A description for the tag. CommonMark syntax MAY be used for rich text representation. */
  "description": z.string().optional().catch(void 0),
  /** Additional external documentation for this tag. */
  "externalDocs": oasExternalDocumentationSchema.optional(),
  "x-scalar-children": xScalarNestedSchema.default([]).optional(),
  /** Hide collections */
  "x-internal": z.boolean().optional(),
  "x-scalar-ignore": z.boolean().optional()
});
const tagSchema = oasTagSchema.extend({
  uid: nanoidSchema.brand(),
  children: z.union([z.string().brand(), z.string().brand()]).array().default([])
});
export {
  oasContactSchema,
  oasExternalDocumentationSchema,
  oasInfoSchema,
  oasLicenseSchema,
  oasTagSchema,
  tagSchema,
  xScalarNestedSchema
};
//# sourceMappingURL=spec-objects.js.map
