import { z } from 'zod';
declare const modifiers: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodDefault<z.ZodOptional<z.ZodEnum<["Meta", "Control", "Shift", "Alt", "default"]>>>, "many">>>;
export type HotKeyModifiers = z.infer<typeof modifiers>;
declare const hotKeys: z.ZodRecord<z.ZodEnum<["Space", "Backspace", "Tab", "Enter", "Escape", "ArrowDown", "ArrowLeft", "ArrowRight", "ArrowUp", "End", "Home", "PageDown", "PageUp", "Delete", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "+", "-", ".", "/", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", ";", "=", ",", "-", ".", "/", "`", "[", "\\", "]", ""]>, z.ZodObject<{
    modifiers: z.ZodOptional<z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodDefault<z.ZodOptional<z.ZodEnum<["Meta", "Control", "Shift", "Alt", "default"]>>>, "many">>>>;
    event: z.ZodEnum<["addTopNav", "closeModal", "closeTopNav", "createNew", "executeRequest", "focusAddressBar", "focusRequestSearch", "jumpToLastTab", "jumpToTab", "navigateSearchResultsDown", "navigateSearchResultsUp", "navigateTopNavLeft", "navigateTopNavRight", "openCommandPalette", "selectSearchResult", "toggleSidebar"]>;
}, "strip", z.ZodTypeAny, {
    event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
    modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
}, {
    event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
    modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt" | undefined)[] | undefined;
}>>;
export type HotKeyConfig = z.infer<typeof hotKeys>;
export declare const workspaceSchema: z.ZodObject<{
    uid: z.ZodBranded<z.ZodDefault<z.ZodOptional<z.ZodString>>, "workspace">;
    name: z.ZodDefault<z.ZodString>;
    /** Workspace description */
    description: z.ZodDefault<z.ZodString>;
    /** List of all collection uids in a given workspace */
    collections: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "collection">, "many">>;
    /** List of all environment uids in a given workspace, TODO: why is this a record? */
    environments: z.ZodDefault<z.ZodRecord<z.ZodString, z.ZodString>>;
    /** Customize hotkeys */
    hotKeyConfig: z.ZodOptional<z.ZodObject<{
        modifiers: z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodDefault<z.ZodOptional<z.ZodEnum<["Meta", "Control", "Shift", "Alt", "default"]>>>, "many">>>;
        hotKeys: z.ZodOptional<z.ZodRecord<z.ZodEnum<["Space", "Backspace", "Tab", "Enter", "Escape", "ArrowDown", "ArrowLeft", "ArrowRight", "ArrowUp", "End", "Home", "PageDown", "PageUp", "Delete", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "*", "+", "-", ".", "/", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", ";", "=", ",", "-", ".", "/", "`", "[", "\\", "]", ""]>, z.ZodObject<{
            modifiers: z.ZodOptional<z.ZodDefault<z.ZodOptional<z.ZodArray<z.ZodDefault<z.ZodOptional<z.ZodEnum<["Meta", "Control", "Shift", "Alt", "default"]>>>, "many">>>>;
            event: z.ZodEnum<["addTopNav", "closeModal", "closeTopNav", "createNew", "executeRequest", "focusAddressBar", "focusRequestSearch", "jumpToLastTab", "jumpToTab", "navigateSearchResultsDown", "navigateSearchResultsUp", "navigateTopNavLeft", "navigateTopNavRight", "openCommandPalette", "selectSearchResult", "toggleSidebar"]>;
        }, "strip", z.ZodTypeAny, {
            event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
            modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
        }, {
            event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
            modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt" | undefined)[] | undefined;
        }>>>;
    }, "strip", z.ZodTypeAny, {
        modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
        hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
            event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
            modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
        }>> | undefined;
    }, {
        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt" | undefined)[] | undefined;
        hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
            event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
            modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt" | undefined)[] | undefined;
        }>> | undefined;
    }>>;
    /** Active Environment ID to use for requests  */
    activeEnvironmentId: z.ZodDefault<z.ZodOptional<z.ZodString>>;
    /** List of all cookie uids in a given workspace */
    cookies: z.ZodDefault<z.ZodArray<z.ZodBranded<z.ZodString, "cookie">, "many">>;
    /** Workspace level proxy for all requests to be sent through */
    proxyUrl: z.ZodOptional<z.ZodString>;
    /** Workspace level theme, we might move this to user level later */
    themeId: z.ZodCatch<z.ZodDefault<z.ZodOptional<z.ZodEnum<["alternate", "default", "moon", "purple", "solarized", "bluePlanet", "deepSpace", "saturn", "kepler", "elysiajs", "fastify", "mars", "laserwave", "none"]>>>>;
    /** Currently selected snippet client */
    selectedHttpClient: z.ZodDefault<z.ZodOptional<z.ZodObject<{
        targetKey: z.ZodString;
        clientKey: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        targetKey: string;
        clientKey: string;
    }, {
        targetKey: string;
        clientKey: string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    uid: string & z.BRAND<"workspace">;
    name: string;
    description: string;
    cookies: (string & z.BRAND<"cookie">)[];
    collections: (string & z.BRAND<"collection">)[];
    environments: Record<string, string>;
    activeEnvironmentId: string;
    themeId: "default" | "alternate" | "moon" | "purple" | "solarized" | "bluePlanet" | "deepSpace" | "saturn" | "kepler" | "elysiajs" | "fastify" | "mars" | "laserwave" | "none";
    selectedHttpClient: {
        targetKey: string;
        clientKey: string;
    };
    hotKeyConfig?: {
        modifiers: ("default" | "Meta" | "Control" | "Shift" | "Alt")[];
        hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
            event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
            modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt")[] | undefined;
        }>> | undefined;
    } | undefined;
    proxyUrl?: string | undefined;
}, {
    uid?: string | undefined;
    name?: string | undefined;
    description?: string | undefined;
    cookies?: string[] | undefined;
    collections?: string[] | undefined;
    environments?: Record<string, string> | undefined;
    hotKeyConfig?: {
        modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt" | undefined)[] | undefined;
        hotKeys?: Partial<Record<"" | "0" | "Space" | "Backspace" | "Tab" | "Enter" | "Escape" | "ArrowDown" | "ArrowLeft" | "ArrowRight" | "ArrowUp" | "End" | "Home" | "PageDown" | "PageUp" | "Delete" | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m" | "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z" | "*" | "+" | "-" | "." | "/" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | ";" | "=" | "," | "`" | "[" | "\\" | "]", {
            event: "addTopNav" | "closeModal" | "closeTopNav" | "createNew" | "executeRequest" | "focusAddressBar" | "focusRequestSearch" | "jumpToLastTab" | "jumpToTab" | "navigateSearchResultsDown" | "navigateSearchResultsUp" | "navigateTopNavLeft" | "navigateTopNavRight" | "openCommandPalette" | "selectSearchResult" | "toggleSidebar";
            modifiers?: ("default" | "Meta" | "Control" | "Shift" | "Alt" | undefined)[] | undefined;
        }>> | undefined;
    } | undefined;
    activeEnvironmentId?: string | undefined;
    proxyUrl?: string | undefined;
    themeId?: unknown;
    selectedHttpClient?: {
        targetKey: string;
        clientKey: string;
    } | undefined;
}>;
/** The base scalar workspace */
export type Workspace = z.infer<typeof workspaceSchema>;
export type WorkspacePayload = z.input<typeof workspaceSchema>;
export {};
//# sourceMappingURL=workspace.d.ts.map