import { formatJsonOrYamlString } from "./parse.js";
import { redirectToProxy } from "./redirect-to-proxy.js";
const OLD_PROXY_URL = "https://api.scalar.com/request-proxy";
const NEW_PROXY_URL = "https://proxy.scalar.com";
async function fetchDocument(url, proxyUrl, prettyPrint = true) {
  if (proxyUrl === OLD_PROXY_URL) {
    proxyUrl = NEW_PROXY_URL;
  }
  const response = await fetch(redirectToProxy(proxyUrl, url));
  if (response.status !== 200) {
    console.error(`[fetchDocument] Failed to fetch the OpenAPI document from ${url} (Status: ${response.status})`);
    if (!proxyUrl) {
      console.warn(
        `[fetchDocument] Tried to fetch the OpenAPI document from ${url} without a proxy. Are the CORS headers configured to allow cross-domain requests? https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS`
      );
    }
    throw new Error(`Failed to fetch the OpenAPI document from ${url} (Status: ${response.status})`);
  }
  if (prettyPrint) {
    return formatJsonOrYamlString(await response.text());
  }
  return await response.text();
}
export {
  fetchDocument
};
//# sourceMappingURL=fetch-document.js.map
