import { redirectToProxy, shouldUseProxy } from "./redirect-to-proxy.js";
async function fetchWithProxyFallback(url, { proxyUrl, cache }) {
  const fetchOptions = {
    cache: cache || "default"
  };
  const shouldTryProxy = shouldUseProxy(proxyUrl, url);
  const initialUrl = shouldTryProxy ? redirectToProxy(proxyUrl, url) : url;
  try {
    const result = await fetch(initialUrl, fetchOptions);
    if (result.ok || !shouldTryProxy) {
      return result;
    }
    return await fetch(url, fetchOptions);
  } catch (error) {
    if (shouldTryProxy) {
      return await fetch(url, fetchOptions);
    }
    throw error;
  }
}
export {
  fetchWithProxyFallback
};
//# sourceMappingURL=fetch-with-proxy-fallback.js.map
