import { normalizeMimeType } from "./normalize-mime-type.js";
function normalizeMimeTypeObject(content) {
  if (!content) {
    return content;
  }
  const newContent = {
    ...content
  };
  Object.keys(newContent).forEach((key) => {
    const newKey = normalizeMimeType(key);
    if (newKey === void 0) {
      return;
    }
    newContent[newKey] = newContent[key];
    if (key !== newKey) {
      delete newContent[key];
    }
  });
  return newContent;
}
export {
  normalizeMimeTypeObject
};
//# sourceMappingURL=normalize-mime-type-object.js.map
