import { isJsonString } from "./parse.js";
const prettyPrintJson = (value) => {
  if (typeof value === "string") {
    if (isJsonString(value)) {
      return JSON.stringify(JSON.parse(value), null, 2);
    }
    return value;
  }
  if (typeof value === "object") {
    try {
      return JSON.stringify(value, null, 2);
    } catch {
      return replaceCircularDependencies(value);
    }
  }
  return value?.toString() ?? "";
};
function replaceCircularDependencies(content) {
  const cache = /* @__PURE__ */ new Set();
  return JSON.stringify(
    content,
    (_key, value) => {
      if (typeof value === "object" && value !== null) {
        if (cache.has(value)) {
          return "[Circular]";
        }
        cache.add(value);
      }
      return value;
    },
    2
  );
}
export {
  prettyPrintJson,
  replaceCircularDependencies
};
//# sourceMappingURL=pretty-print-json.js.map
