import type { SecurityScheme } from '@scalar/types/entities';
import type { Operation } from '../../entities/spec/operation.js';
/** Parses a list of selected security scheme uids which may be an array or single uid and returns a flattened array of security schemes */
export declare const getSchemes: (selectedSecuritySchemes: Operation["selectedSecuritySchemeUids"], securitySchemes: Record<SecurityScheme["uid"], SecurityScheme>) => NonNullable<{
    type: "apiKey";
    value: string;
    name: string;
    uid: string & import("zod").BRAND<"securityScheme">;
    nameKey: string;
    in: "cookie" | "query" | "header";
    description?: string | undefined;
} | {
    type: "http";
    uid: string & import("zod").BRAND<"securityScheme">;
    nameKey: string;
    scheme: "basic" | "bearer";
    bearerFormat: string;
    username: string;
    password: string;
    token: string;
    description?: string | undefined;
} | {
    type: "openIdConnect";
    uid: string & import("zod").BRAND<"securityScheme">;
    nameKey: string;
    openIdConnectUrl: string;
    description?: string | undefined;
} | {
    type: "oauth2";
    uid: string & import("zod").BRAND<"securityScheme">;
    nameKey: string;
    flows: {
        password?: {
            type: "password";
            username: string;
            password: string;
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            "x-scalar-client-id": string;
            tokenUrl: string;
            clientSecret: string;
            "x-scalar-security-query"?: Record<string, string> | undefined;
        } | undefined;
        implicit?: {
            type: "implicit";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            "x-scalar-client-id": string;
            authorizationUrl: string;
            "x-scalar-redirect-uri": string;
            "x-scalar-security-query"?: Record<string, string> | undefined;
        } | undefined;
        clientCredentials?: {
            type: "clientCredentials";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            "x-scalar-client-id": string;
            tokenUrl: string;
            clientSecret: string;
            "x-scalar-security-query"?: Record<string, string> | undefined;
        } | undefined;
        authorizationCode?: {
            type: "authorizationCode";
            token: string;
            refreshUrl: string;
            scopes: Record<string, string>;
            selectedScopes: string[];
            "x-scalar-client-id": string;
            authorizationUrl: string;
            "x-scalar-redirect-uri": string;
            tokenUrl: string;
            clientSecret: string;
            "x-usePkce": "SHA-256" | "plain" | "no";
            "x-scalar-security-query"?: Record<string, string> | undefined;
        } | undefined;
    };
    description?: string | undefined;
    'x-default-scopes'?: string | string[] | undefined;
}>[];
//# sourceMappingURL=get-schemes.d.ts.map