const hasToken = (scheme) => {
  if (scheme.type === "apiKey") {
    return Boolean(scheme.value);
  }
  if (scheme.type === "http") {
    return Boolean(
      scheme.scheme === "bearer" && scheme.token || scheme.scheme === "basic" && scheme.username && scheme.password
    );
  }
  if (scheme.type === "oauth2") {
    return Boolean(
      scheme.flows.authorizationCode?.token || scheme.flows.clientCredentials?.token || scheme.flows.password?.token || scheme.flows.implicit?.token
    );
  }
  return false;
};
export {
  hasToken
};
//# sourceMappingURL=has-token.js.map
