import { parse } from "flatted";
import { DATA_VERSION_LS_LEY } from "../migrations/data-version.js";
const parseLocalStorage = (lsKey) => {
  const item = localStorage.getItem(lsKey) || "[{}]";
  const data = item[0] === "[" ? parse(item) : JSON.parse(item);
  return data;
};
const getLocalStorageVersion = () => {
  const collectionStr = localStorage.getItem("collection");
  const dataVersion = localStorage.getItem(DATA_VERSION_LS_LEY);
  if (dataVersion) {
    return dataVersion;
  }
  if (!collectionStr?.length || collectionStr?.[0] === "{") {
    return "0.0.0";
  }
  try {
    const [collection] = Object.values(parse(collectionStr) ?? {});
    if (collection?.type === "collection") {
      return "2.1.0";
    }
    return "0.0.0";
  } catch (e) {
    console.error(e);
    return "0.0.0";
  }
};
export {
  getLocalStorageVersion,
  parseLocalStorage
};
//# sourceMappingURL=local-storage.js.map
