import { getLocalStorageVersion, parseLocalStorage } from "../migrations/local-storage.js";
import { semverLessThan } from "../migrations/semver.js";
import { migrate_v_2_1_0 } from "../migrations/v-2.1.0/migration.js";
import { migrate_v_2_2_0 } from "../migrations/v-2.2.0/migration.js";
import { migrate_v_2_3_0 } from "../migrations/v-2.3.0/migration.js";
import { migrate_v_2_4_0 } from "../migrations/v-2.4.0/migration.js";
import { migrate_v_2_5_0 } from "../migrations/v-2.5.0/migration.js";
const migrator = () => {
  const dataVersion = getLocalStorageVersion();
  console.info("Data version: " + dataVersion);
  let data = {
    collections: parseLocalStorage("collection"),
    cookies: parseLocalStorage("cookie"),
    environments: parseLocalStorage("environment"),
    requestExamples: parseLocalStorage("requestExample"),
    requests: parseLocalStorage("request"),
    securitySchemes: parseLocalStorage("securityScheme"),
    servers: parseLocalStorage("server"),
    tags: parseLocalStorage("tag"),
    workspaces: parseLocalStorage("workspace")
  };
  if (semverLessThan(dataVersion, "2.1.0")) {
    data = migrate_v_2_1_0(data);
  }
  if (semverLessThan(dataVersion, "2.2.0")) {
    data = migrate_v_2_2_0(data);
  }
  if (semverLessThan(dataVersion, "2.3.0")) {
    data = migrate_v_2_3_0(data);
  }
  if (semverLessThan(dataVersion, "2.4.0")) {
    data = migrate_v_2_4_0(data);
  }
  if (semverLessThan(dataVersion, "2.5.0")) {
    data = migrate_v_2_5_0(data);
  }
  data = {
    collections: Object.values(data.collections),
    cookies: Object.values(data.cookies),
    environments: Object.values(data.environments),
    requestExamples: Object.values(data.requestExamples),
    requests: Object.values(data.requests),
    securitySchemes: Object.values(data.securitySchemes),
    servers: Object.values(data.servers),
    tags: Object.values(data.tags),
    workspaces: Object.values(data.workspaces)
  };
  return data;
};
export {
  migrator
};
//# sourceMappingURL=migrator.js.map
